/*
 * @Author: 吴文洁
 * @Date: 2020-04-29 10:26:32
 * @LastEditors: yuananting
 * @LastEditTime: 2021-07-29 14:03:23
 * @Description: 内容线路由配置
 */
import Home from '@/modules/home/Home';
import EmployeesManagePage from '@/modules/store-manage/EmployeesManagePage';
import EmployeeManage from '@/modules/college-manage/EmployeeManage';
import personalInfoPage from '@/modules/personalInfo';
import UserManagePage from '@/modules/store-manage/UserManagePage';
import UserManage from '@/modules/college-manage/UserManagePage';
import StoreDecorationPage from '@/modules/store-manage/StoreDecorationPage';
import CourseCatalogPage from '@/modules/store-manage/CourseCatalogPage';
import LiveCoursePage from '@/modules/course-manage/LiveCoursePage';
import AddLivePage from '@/modules/course-manage/AddLive';
import VideoCoursePage from '@/modules/course-manage/video-course';
import GraphicsCoursePage from '@/modules/course-manage/graphics-course';
import OfflineCoursePage from '@/modules/course-manage/offline-course';
import AddVideoCoursePage from '@/modules/course-manage/video-course/AddVideoCourse';
import AddGraphicsCoursePage from '@/modules/course-manage/graphics-course/AddGraphicsCourse';
import AddOfflineCoursePage from '@/modules/course-manage/offline-course/AddOfflineCourse';
// import DataList from '@/modules/course-manage/DataList/DataList';
// import ClassBook from '@/modules/resource-disk';
import ResourceDisk from '@/modules/resource-disk';
import SwitchRoute from '@/modules/root/SwitchRoute';
import PlanPage from '@/modules/plan-manage/PlanPage';
import AddPlanPage from '@/modules/plan-manage/AddPlan';
import LearningDataPage from '@/modules/plan-manage/LearningData';
import StoreInfoPage from '@/modules/store-manage/StoreInfo';
import CourseCategoryManage from '@/modules/teach-tool/components/CourseCategoryManage';
import QuestionManageIndex from '@/modules/teach-tool/question-manage/Index';
import PaperManageIndex from '@/modules/teach-tool/paper-manage/Index';
import ExaminationManagerIndex from '@/modules/teach-tool/examination-manager/Index';
import ExaminationManagerTestDetail from '@/modules/teach-tool/examination-manager/TestDetailPage';
import KnowledgeBase from '@/modules/knowledge-base/index';
import CollegeInfoPage from '@/modules/college-manage/CollegeInfoPage';
import TrainTaskPage from '@/modules/task-center/TrainTaskPage';
import AddTrainTask from '@/modules/task-center/AddTrainTask';

const mainRoutes = [
  {
    path: '/home',
    component: Home,
    name: '中心首页',
  },
  {
    path: '/employees-manage',
    component: EmployeesManagePage,
    name: '员工管理',
  },
  {
    path: '/college-employee',
    component: EmployeeManage,
    name: '员工管理',
  },
  {
    path: '/personal-info',
    component: personalInfoPage,
    name: '个人信息',
  },
  {
    path: '/user-manage',
    component: UserManagePage,
    name: '学员管理',
  },
  {
    path: '/college-user',
    component: UserManage,
    name: '学员管理',
  },
  {
    path: '/store-decoration',
    component: StoreDecorationPage,
    name: '学院装修',
  },
  {
    path: '/live-course',
    component: LiveCoursePage,
    name: '直播课',
  },
  {
    path: '/video-course',
    component: VideoCoursePage,
    name: '线上课',
  },
  {
    path: '/graphics-course',
    component: GraphicsCoursePage,
    name: '图文课',
  },
  {
    path: '/offline-course',
    component: OfflineCoursePage,
    name: '线下课',
  },
  {
    path: '/create-live-course',
    component: AddLivePage,
    name: '创建直播课',
  },
  {
    path: '/create-video-course',
    component: AddVideoCoursePage,
    name: '创建线上课',
  },
  {
    path: '/knowledge-base',
    // component:ResourceDisk,
    component: KnowledgeBase,
    name: '知识库',
  },
  {
    path: '/create-graphics-course',
    component: AddGraphicsCoursePage,
    name: '创建图文课',
  },
  {
    path: '/create-offline-course',
    component: AddOfflineCoursePage,
    name: '创建线下课',
  },
  {
    path: '/resource-disk',
    component: ResourceDisk,
    name: '资料云盘',
  },
  {
    path: '/question-manage-index',
    component: QuestionManageIndex,
    name: '题库',
  },
  {
    path: '/paper-manage-index',
    component: PaperManageIndex,
    name: '试卷',
  },
  {
    path: '/examination-manage-index',
    component: ExaminationManagerIndex,
    name: '考试',
  },
  {
    path: '/test-detail/:testId',
    component: ExaminationManagerTestDetail,
    // () => import('@/modules/teach-tool/examination-manager/TestDetailPage'),
    name: '答题详情',
  },
  {
    path: '/course-category-manage',
    component: CourseCategoryManage,
    name: '分类管理',
  },
  {
    path: '/switch-route',
    component: SwitchRoute,
    name: '登录后跳转承载页',
  },
  {
    path: '/plan',
    component: PlanPage,
    name: '培训计划',
  },
  {
    path: '/train-task',
    component: TrainTaskPage,
    name: '培训任务',
  },
  {
    path: '/create-train-task',
    component: AddTrainTask,
    name: '创建培训任务',
  },
  {
    path: '/create-plan',
    component: AddPlanPage,
    name: '创建线上课',
  },
  {
    path: '/store-info',
    component: StoreInfoPage,
    name: '学院信息',
  },
  {
    path: '/college-info',
    component: CollegeInfoPage,
    name: '学院信息',
  },
  {
    path: '/learning-data',
    component: LearningDataPage,
    name: '学习数据',
  },
];

export default mainRoutes;
