/*
 * @Author: zhangleyuan
 * @Date: 2021-02-20 16:13:39
 * @LastEditors: zhangleyuan
 * @LastEditTime: 2021-02-25 17:49:09
 * @Description: 描述一下
 * @@Copyrigh: © 2020 杭州杰竞科技有限公司 版权所有
 */
import React, { useEffect, useState } from "react";
import { Button, message, Modal } from 'antd';
import ShowTips from "@/components/ShowTips";
import Breadcrumbs from "@/components/Breadcrumbs";
import BasicInfo from './components/BasicInfo';
import TrainingTask from './components/TrainingTask'

import './AddPlan.less'
const DEFAULT_BASIC_DATA = {
    planName:"",
    enableState:"YES",
    selectOperatorList:[],
    instro:'',
    operateType:'All_Operate',
    percentCompleteLive:80,
    percentCompleteVideo:80
}
function AddPlan() {
  const [basicData,setBasicData] = useState(DEFAULT_BASIC_DATA);

    function handleChangeBasicInfo(field, value){
        

        console.log('field',value);

        setBasicData( {
            ...basicData,
            [field]: value,
        }
    )
  }
  return (
    <div className="page add-plan-page">   
        <Breadcrumbs
            navList={type == "add" ? "新建培训计划" : "编辑培训计划"}
        />
        <div className="box">
            <div className="show-tips">
                <ShowTips message="请遵守国家相关规定，切勿上传低俗色情、暴力恐怖、谣言诈骗、侵权盗版等相关内容，小麦企培保有依据国家规定及平台规则进行处理的权利" />
            </div>
            <div className="add-plan-page__form">
                <div className="basic-info__wrap">
                    <div className="title">基本信息</div>
                    <BasicInfo 
                      data={basicData}
                      onChange={handleChangeBasicInfo}
                    />
                </div>
                <div className="basic-info__wrap">
                    <div className="title">培训任务</div>
                    <TrainingTask/>
                </div>
            </div> 
        </div>
        <div className="footer">
            <Button>取消</Button>
            <Button type="primary">保存</Button>
        </div>
    </div>    
  )

}
export default AddPlan;