/*
 * @Author: wufan
 * @Date: 2020-11-30 10:47:38
 * @LastEditors: wufan
 * @LastEditTime: 2020-12-03 11:37:42
 * @Description: 用户管理页面
 * @@Copyrigh: © 2020 杭州杰竞科技有限公司 版权所有
 */

import React, { useEffect, useState } from "react";
import { withRouter } from "react-router-dom";
import _ from "underscore";
import { PageControl } from "@/components";
import { Table, Modal, message, Row, Col, Input, DatePicker } from "antd";
import StoreService from "@/domains/store-domain/storeService";
import User from "@/common/js/user";

import "./UserManagePage.less";
import moment from "moment";
const { Search } = Input;
const { RangePicker } = DatePicker;

declare var window: any;

function UserManagePage() {
  const [userList, setUserList] = useState([]);
  const [query, setQuery] = useState({
    current: 0,
    size: 10,
    nickName: "",
    phone: "",
    storeId: User.getStoreId(),
    registerBegin: null,
    registerEnd: null,
  });
  const [total, setTotal] = useState(0);
  const [model, setModel] = useState(null);
  const [isModalOpen, setIsModalOpen] = useState(false);
  const [isManager, setIsManager] = useState(true);
  const [isNormal, setIsNormal] = useState(true);
  const [choosedItem, setChooseItem] = useState({});
  const [nickName, setNickName] = useState("");
  const [phone, setPhone] = useState("");

  useEffect(() => {
    getUserList();
  }, [query]);

  function getUserList() {
    let _query = _.clone(query);
    _query.current = query.current + 1;
    StoreService.getUserList(_query).then((res: any) => {
      setUserList(res.result.records);
      setTotal(res.result.total);
    });
  }

  function parseColumn() {
    return [
      {
        title: "用户姓名",
        dataIndex: "nickName",
        render: (val: string) => {
          return (
            <div className="coupon-info">
              <span className="title">{val}</span>
            </div>
          );
        },
      },
      {
        title: "手机号",
        dataIndex: "phone",
        key: "phone",
        render: (val: string) => {
          return <div>{val}</div>;
        },
      },
      {
        title: "注册时间",
        dataIndex: "created",
        key: "created",
        render: (val: string) => {
          return <div>{moment(val).format("YYYY-MM-DD HH:mm:ss")}</div>;
        },
      },
    ];
  }

  function handleQuery(name: string, value: any) {
    const _query = _.clone(query);
    // _query[name] = value;
    setQuery(_query);
  }

  return (
    <div className=" page user-manage-page">
      <div className="page-content">
        <div className="content-header">用户管理</div>
        <div className="box">
          <div className="box-header">
            <div
              style={{
                display: "flex",
                alignItems: "center",
                justifyContent: "space-between",
                padding: "15px 0 10px",
              }}
            >
              <div style={{ flex: 1 }}>
                搜索用户：
                <Search
                  style={{
                    width: 300,
                    marginRight: 40,
                  }}
                  placeholder="搜索用户姓名/手机号"
                  // onChange={(event) => {
                  //   const val = event.target.value;

                  // }}
                  onSearch={(value) => {
                    const _query = { ...query };
                    if (value) {
                      console.log("value", value);
                      const isPhone = (value || "").match(/^\d+$/);
                      const name = isPhone ? "phone" : "nickName";
                      _query[name] = value;
                    } else {
                      _query.nickName = "";
                      _query.phone = "";
                    }
                    setQuery(_query);
                  }}
                />

              </div>

              <div style={{ flex: 1 }}>
                注册时间：
                <RangePicker
                  showTime
                  style={{ flex: 1, width: "auto" }}
                  value={
                    query.registerBegin
                      ? [moment(query.registerBegin), moment(query.registerEnd)]
                      : null
                  }
                  format={"YYYY-MM-DD"}
                  disabledDate={(current) => {
                    return (
                      current &&
                      current.valueOf() > moment().endOf("day").valueOf()
                    );
                  }}
                  onChange={(dates: any) => {
                    const _query = _.clone(query);
                    _query.registerBegin = dates ? dates[0].valueOf() : null;
                    _query.registerEnd = dates ? dates[1].valueOf() : null;
                    setQuery({
                      ..._query,
                      current: 1,
                    });
                  }}
                />
              </div>
            </div>
          </div>
          <div className="box-body">
            <Table
              size={"middle"}
              pagination={false}
              dataSource={userList}
              columns={parseColumn()}
              rowKey={(item: any) => item.id}
              bordered
            />
          </div>
          <div className="box-footer">
            <PageControl
              current={query.current}
              pageSize={query.size}
              total={total}
              toPage={(page: any) => {
                const queryStates = _.clone(query);
                queryStates.current = page;
                setQuery(queryStates);
              }}
            />
          </div>
        </div>
      </div>
    </div>
  );
}

export default withRouter(UserManagePage);
