/*
 * @Author: Michael
 * @Date: 2020-02-10 10:08:39
 * @Last Modified by: 吴文洁
 * @Last Modified time: 2020-07-16 11:32:50
 */
const DEFAULT_SIZE_UNIT = 1000 * 1000; // 将B转换成M

const GIGABYTE_SIZE_UNIT = 1000 * 1000 * 1000; // 转换为G

const SupportFileType = [
  "application/msword",
  "text/csv",
  "application/vnd.ms-excel",
  "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet",
  "application/vnd.ms-powerpoint",
  "application/pdf",
  "image/jpeg",
  "image/png",
  "audio/mpeg",
  "audio/mp4",
  "video/mp4",
  "application/vnd.openxmlformats-officedocument.wordprocessingml.document",
  "application/vnd.openxmlformats-officedocument.presentationml.presentation",
  "audio/mp3",
  "application/wps-office.pdf",
  "application/wps-office.xls"
];

const LocalFileType = [
  "application/msword",
  "application/vnd.ms-excel",
  "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet",
  "application/vnd.ms-powerpoint",
  "application/pdf",
  "application/vnd.openxmlformats-officedocument.wordprocessingml.document",
  "application/vnd.openxmlformats-officedocument.presentationml.presentation",
  "application/wps-office.pdf",
  "application/wps-office.xls"
]

const FileVerifyMap = {
  "application/msword": {
    type: "word",
    maxSize: 100
  },
  "application/vnd.openxmlformats-officedocument.wordprocessingml.document": {
    type: "word",
    maxSize: 100
  },
  "text/csv": {
    type: "Excel",
    maxSize: 10
  },
  "application/vnd.ms-excel": {
    type: "Excel",
    maxSize: 10
  },
  "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet": {
    type: "Excel",
    maxSize: 10
  },
  "application/wps-office.xls": {
    type: "Excel",
    maxSize: 10
  },
  "application/vnd.ms-powerpoint": {
    type: "PPT",
    maxSize: 100
  },
  "application/vnd.openxmlformats-officedocument.presentationml.presentation": {
    type: "PPT",
    maxSize: 100
  },
  "application/pdf": {
    type: "PDF",
    maxSize: 100
  },
  "application/wps-office.pdf": {
    type: "PDF",
    maxSize: 100
  },
  "image/jpeg": {
    type: "JPG",
    maxSize: 5
  },
  "image/png": {
    type: "JPG",
    maxSize: 5
  },
  "image/jpg": {
    type: "JPG",
    maxSize: 5
  },
  "image/gif": {
    type: "GIF",
    maxSize: 5
  },
  "audio/mpeg": {
    type: "MP3",
    maxSize: 20
  },
  "audio/mp3": {
    type: "MP3",
    maxSize: 20
  },
  "audio/mp4": {
    type: "MP4",
    maxSize: 500
  },
  "video/mp4": {
    type: "MP4",
    maxSize: 500
  }
};

const LessonFileTypeEnum = {
  TEACH_PLAN: "教案",
  COURSEWARE: "课件",
  HOMEWORK: "作业"
};

const FileTypeIcon = {
  word: "https://image.xiaomaiketang.com/xm/6biwHTSPe5.png",
  DOCX: "https://image.xiaomaiketang.com/xm/6biwHTSPe5.png",
  DOC: "https://image.xiaomaiketang.com/xm/6biwHTSPe5.png",
  DOCX: "https://image.xiaomaiketang.com/xm/6biwHTSPe5.png",
  // 第一期备后端返回的是长的文件类型，备课版改版之后后端返回的是短的文件类型，且大写，所以做个兼容，下面的EXCEl也是一样的
  WORD: "https://image.xiaomaiketang.com/xm/6biwHTSPe5.png", 
  Excel: "https://image.xiaomaiketang.com/xm/h6a6eF882a.png", 
  EXCEL: "https://image.xiaomaiketang.com/xm/h6a6eF882a.png", 
  PPT: "https://image.xiaomaiketang.com/xm/847pFAdYGW.png",
  PPTX: "https://image.xiaomaiketang.com/xm/847pFAdYGW.png",
  PDF: "https://image.xiaomaiketang.com/xm/rrEJMNkhTG.png",
  MP3: "https://image.xiaomaiketang.com/xm/ykjnSWDyQ6.png",
  MP4: "https://image.xiaomaiketang.com/xm/whSYMTdR57.png",
  JPG: "https://image.xiaomaiketang.com/xm/XRkX8JBTPs.png",
  JPEG: "https://image.xiaomaiketang.com/xm/XRkX8JBTPs.png",
  PNG: "https://image.xiaomaiketang.com/xm/XRkX8JBTPs.png",
  GIF: "https://image.xiaomaiketang.com/xm/XRkX8JBTPs.png",
  BMP: "https://image.xiaomaiketang.com/xm/XRkX8JBTPs.png",
};

const UploadIcon = "https://image.xiaomaiketang.com/xm/4DXNrZWWsd.png";

const FailIcon = "https://image.xiaomaiketang.com/xm/ZkWbrrbiRn.png";

const StorageColor = {
  blue: "#58B7EF",
  yellow: "linear-gradient(to right, #FBD140, #FFA201)",
  red: "#EC4B35"
};

const suffixMap = {
  'doc': 'application/msword',
  'docx': 'application/vnd.openxmlformats-officedocument.wordprocessingml.document',
  'ppt': 'application/vnd.ms-powerpoint',
  'pptx': 'application/vnd.openxmlformats-officedocument.presentationml.presentation',
  'pdf': 'application/pdf',
  'xlsx': 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet',
  'xls': 'application/vnd.ms-excel'
}

const DISK_MAP = {
  MYSELF: '我的文件',
  COMMON: '公共文件',
  EMPLOYEE: '员工文件'
}

const NonCompliantFileMap = {
  'video': {
    accept: 'video/mp4',
    confirm: {
      title: '文件过大，无法上传',
      content: '为保障学员的观看体验，上传的视频大小不能超过100M',
    },
    tooltip: '格式支持mp4，大小不超过100M'
  }
}

export {
  DEFAULT_SIZE_UNIT,
  FileVerifyMap,
  FileTypeIcon,
  LessonFileTypeEnum,
  UploadIcon,
  FailIcon,
  StorageColor,
  GIGABYTE_SIZE_UNIT,
  SupportFileType,
  suffixMap,
  LocalFileType,
  DISK_MAP,
  NonCompliantFileMap
};


