import React from 'react';
import { Modal } from "antd";

import "./AccountChargeModal.less";
class ChargeArgeement extends React.Component {
  constructor(props) {
    super(props);
    this.state = {
      capitalTotalAmount: "",
      totalAmount: "",
      buyerPhone: "",
      buyer: "",
    };
  }
  componentDidMount() {
    this.getProtcolContent();
  }
  getProtcolContent() {
    const { id } = this.props;
    const { instId } = window.currentUserInstInfo;
    if (!!id) {
      const params = { protocolId: id, instId };
      axios
        .Business("public/liveAssets/protocolDetail", params)
        .then((res) => {
          const {
            capitalTotalAmount,
            totalAmount,
            buyerPhone,
            buyer,
          } = res.result;
          this.setState({
            capitalTotalAmount,
            totalAmount,
            buyerPhone,
            buyer,
          });
        });
    }
  }
  render() {
    return (
      <Modal
        title="云课堂充值服务协议"
        visible={true}
        width={800}
        className="charge-agreement-modal"
        footer={null}
        maskClosable={false}
        onCancel={() => {
          this.props.close();
        }}
      >
        <div>
          <div className="agreement-title">
            “互动班课”技术服务许可及服务协议”
          </div>
          <div className="agreement-main">
            <span>软件采购方：{this.state.buyer}</span>
          </div>
          <div className="agreement-main">
            <span>联系方式：{this.state.buyerPhone}</span>{" "}
            <span style={{marginLeft: 300}}>（以下简称 “甲方” ）</span>
          </div>
          <div className="agreement-main-text border-all">
            <p> 授权许可人：杭州杰竞科技有限公司 （以下简称 “乙方” ） </p>
            <p>地址：杭州市西湖区古墩路598号同人广场A座三楼 </p>
            <p>邮编：310012</p>
            <p>联系电话：0571-87007093</p>
          </div>
          <div className="agreement-main-text">
            “互动班课”技术服务是乙方自主设计研发的用于服务教育机构在线课堂的工具类产品。因从事教育相关的经营活动以及自身管理需要，甲方向乙方购买“互动班课”技术服务的相关使用权，双方在真实、充分地表达各自意愿的基础上，根据《中华人民共和国合同法》和相关法律法规的规定，特订立以下合同条款：
          </div>
          <p className="agreement-sub-title">一、授权使用内容</p>
          <div className="agreement-main-text">
            乙方授权使用的“互动班课”技术服务包含以下内容：互动班课直播工具、充值账户等服务。
          </div>
          <div className="agreement-main-text">
            乙方许可甲方在本合同约定期限内使用“互动班课”技术服务包括了基于PC端的操作系统、基于PC客户端的上课操作系统、基于手机APP的家长端上课操作系统，以及未来计划基于手机H5端的家长操作环境；同时乙方负责甲方在使用“互动班课”技术服务的期限内，提供必要的培训、指导、帮助和技术支持（包含：产品布设、使用培训、数据处理、后期维护等）。
          </div>
          <p className="agreement-sub-title">二、计价标准与付款方式</p>
          <div className="agreement-main-text">
            1、“互动班课”在线课堂计价内容和计价标准如下：
            <br />
            <span className="agreement-tip">
              计价内容：直播课时费、录制费。
            </span>
            <span className="agreement-tip">
              其中，直播课时费依据直播间上课师生人数、直播教室类型、直播时长收取；录制费依据回放视频时长收取。
            </span>
            <br />
            <span className="agreement-tip"> 计价标准：</span>
            <br />
            <span className="agreement-tip">
              【直播时长费】计算公式：每节课上课费用=排课时长*计费人数*课时单价（元/小时）
            </span>
            <br />
            <span className="agreement-tip">
              排课时长：按小时计算，0.5h起，不足0.5h的按0.5h计算
            </span>
            <br />
            <span className="agreement-tip">
              {"计费人数：累积在线时长>=10min的上课老师、学生、助教人数总和"}
            </span>
            <br />
            <span className="agreement-tip">
              课时单价：不同直播教室类型的课时单价（元/人/小时）不同，分别如下
            </span>
            <br />
            <br />
            <span className="agreement-tip">1人上台：3元/人/小时</span>
            <br />
            <span className="agreement-tip">2-6人上台：3元/人/小时</span>
            <br />
            <span className="agreement-tip">7-8人上台：4元/人/小时</span>
            <br />
            <span className="agreement-tip">9-12人上台：8元/人/小时</span>
            <br />
            <span className="agreement-tip">
              【录制费】计算公式：回放视频时长*单价（2元/小时）
            </span>
            <br />
            <span className="agreement-tip">
              录制费依据回放视频生成后的回放视频时长进行计算，回放视频时长按0.5h起收，不足0.5h按0.5h结算。
            </span>
            <br />
          </div>
          <div className="agreement-main-text">
            2、以下为用户在 “互动班课”后台可选的增值服务：
            <li>
              （1）云端录课、网页直播和网页回放功能：云端录课、网页直播和网页回放功能：乙方对云端录课功能按甲方实际录课视频的时长进行收费（2元/小时），最小计费单位为分钟，收费时长以计算课节消费的时长为上限。网页直播和网页回放，暂时免费。开通收费将提前30天通知甲方。
            </li>
            <li>
              （2）结算方式：选择“互动班课”在线课堂服务需要预存【500】元课时费，收费系统按实际发生的课时使用数扣费。合同到期续签时不用再预存上述费用，账户余额可继续使用。为不影响正常上课，甲方应在余额耗尽前及时续费，余额不足时将限制甲方的功能使用。因余额不足导致甲方损失的应由甲方自行承担，每次续费金额应不低于【500】元。
              甲方可在自己系统后台进行自主充值。如在本合同的期限内，甲方未按照前述约定续费，则乙方有权在甲方预存的费用使用完毕后，停止向甲方提供本合同项下的技术服务，并按照本合同的约定合同解除而无需承担任何责任。合同到期后，如甲方不再续签，但仍有账户余额，合同相关服务自动延续三个月，三个月后合同照常终止，此后如仍有余额合同照常终止，如需继续使用须进行续签。
            </li>
            <li>
              （4）甲方可以在 b.xiaomai5.com 随时查询甲方的付费记录及课时使用清单。乙方在收到甲方支付的预存课时费或续费后，根据甲方发票申请信息开具发票。
            </li>
          </div>
          <div className="agreement-main-text">
            3、甲方本次购买“互动班课”技术服务明细如下：其中价格__元为赠送充值内容
          </div>
          <div className="agreement-main-text">
            4、甲方本次购买技术服务金额合计为：__元，
          </div>
          <div className="agreement-main-text">
            大写为：__元整。
          </div>

          <div className="agreement-main-text">
            5、甲方确认开户校区系统账号为唯一云课堂充值账户，甲方可在开户、充值前进行核对。
          </div>
          <div className="agreement-main-text">
            6、双方约定，乙方收到由甲方支付的相应款项起即时为其开通云课堂账户，若甲方指定的开户日期早于约定开户日期，则以甲方指定的开户日期为准。
          </div>
          <div className="agreement-main-text">
            7、双方约定，乙方收到由甲方在线支付的相应款项起即时完成互动班课账户的充值，若甲方委托线下支付，则乙方在收到款项起第90天内为其完成互动班课账户的充值，若甲方指定的充值日期早于约定充值日期，则以甲方指定的充值日期为准。
          </div>
          <div></div>
          <p className="agreement-sub-title">三、甲方的权利和义务</p>
          <div className="agreement-main-text">
            1、甲方有权要求乙方为其初始数据的整理与编辑工作提供指导。
          </div>
          <div className="agreement-main-text">
            2、甲方有权要求乙方为甲方提供系统技术服务的操作培训。
          </div>
          <div className="agreement-main-text">
            3、甲方需妥善保管相关充值账户账号密码，同时不得利用“互动班课”技术服务从事任何违法、违规活动。未经乙方书面同意，甲方不得另行转让、出借账号或者以其他方式变相给第三方使用，否则乙方有权关闭账号或要求甲方赔偿损失。甲方因内部员工误操作或恶意删除相关数据导致的数据丢失，乙方不负责进行恢复。
          </div>
          <div className="agreement-main-text">
            4、甲方在使用“互动班课”技术服务过程中，必须遵循以下原则：
            <li>
              （1）甲方有权通过乙方提供的“互动班课”在线教室平台，自由使用该平台所提供的所有功能，并有权得到乙方相应的技术支持和服务，并遵守所有与网络服务有关的法律法规、行业规定以及协议约定。
            </li>
            <li>
              （2）甲方必须遵守《计算机信息网络国际联网安全保护管理办法》，《中华人民共和国计算机信息网络国际联网管理暂行规定》，《中华人民共和国计算机信息系统安全保护条例》，《中华人民共和国电信条例》，《互联网信息服务管理办法》和国家其他有关法律、法规、条例，不得进行任何违法经营活动。甲方承诺其利用乙方提供的技术服务发布的信息、召开的会议或进行的任何经营行为不会违反上述规定，否则甲方应承担因违反上述规定而引起的法律责任，并对因此给乙方造成的经济、声誉损失承担赔偿责任。
            </li>
            <li>
              （3）不得利用“互动班课”技术服务进行任何可能对互联网或移动网正常运转造成不利影响的行为；
            </li>
            <li>
              （4）不得利用“互动班课”技术服务上传、展示或传播任何虚假的、骚扰性的、中伤他人的、辱骂性的、恐吓性的、庸俗淫秽的或其他任何非法信息资料；甲方若出现淫秽、违反宪法、法律明确规定的画面或言论而被第三方投诉，则乙方有权无条件终止本协议并要求甲方进行相应赔偿。
            </li>
            <li>
              （5）不得侵犯其他任何第三方的专利权、著作权、商标权、名誉权或其他任何合法权益；
            </li>
            <li>
              （6）不得利用“互动班课”技术服务进行任何不利于双方合作的行为。
            </li>
            <li>
              （7）甲方使用在线教室平台及乙方提供的技术服务时所产生的包括但不限于课件、音频、视频等内容（下称“甲方衍生作品”）的知识产权全部归甲方所有。
            </li>
          </div>
          <div className="agreement-main-text">
            5、甲方违法或违反合同使用“互动班课”产生的后果乙方概不负责。甲方使用“互动班课”过程中因违反第三方的相关管理规定导致的后果由其自行承担。
          </div>
          <p className="agreement-sub-title">四、乙方的权利和义务</p>
          <div className="agreement-main-text">
            {" "}
            1、乙方将为甲方提供在线课堂的操作培训；
          </div>
          <div className="agreement-main-text">
            2、乙方将为甲方解决在线课堂使用中遇到的问题；
          </div>
          <div className="agreement-main-text">
            3、乙方作为本合同所述产品的软件著作权人，负责“互动班课”的技术支持、产品升级、后台数据统计等事项；
          </div>
          <div className="agreement-main-text">
            4、乙方负责“互动班课”技术服务的数据安全与技术运维服务；
          </div>
          <div className="agreement-main-text">
            5、乙方配合甲方进行合理的品牌宣传、推广活动，具体执行方案需双方协商一致。
          </div>
          <p className="agreement-sub-title">五、知识产权</p>
          <div className="agreement-main-text">
            1、“互动班课”技术服务（包括：PC端后台管理系统、PC客户端、移动端APP等），均系乙方自主研发完成。“互动班课”技术服务涉及的著作权、商标权、专利权、商业秘密等全部知识产权，以及相关的信息内容，包括但不限于：文字表述及其组合、图标、图饰、图表、色彩、界面设计、版面框架、有关数据、印刷材料及电子文档等均受中华人民共和国著作权法、商标法、专利法、反不正当竞争法和相应的国际条约以及其他知识产权法律法规的保护，
            除涉及第三方授权的软件或技术外，乙方享有上述全部知识产权及所有权。
          </div>
          <div className="agreement-main-text">
            2、基于履行本合同之目的，甲方在合同有效期内享有不可转让的、非独占性的产品使用权。甲方不得进行任何反向编译或试图提取产品源代码的行为，不得创作任何版权衍生作品。
          </div>
          <div className="agreement-main-text">
            3、甲方不得从事以任何形式损害乙方知识产权的行为，同时应采取有效措施促使其雇员按照本合同的规定维护乙方的知识产权。
          </div>
          <div className="agreement-main-text">
            4、未经双方同意，双方均不得以商业经营为目的，擅自使用对方的商标、标识等商业信息。
          </div>

          <p className="agreement-sub-title">六、保密条款</p>
          <div className="agreement-main-text">
            1、在本合同的履行期，双方应当对另一方的商务、财务、技术、产品信息、用户资料或其他标明保密的文件保守秘密，未经信息利益方书面同意，另一方不得向任何第三方进行披露。但以下特定情形除外:
            <br />
            （1）根据法律法规规定或有权机关的指示提供;
            <br />
            （2）信息利益方自行向第三方公开其个人隐私信息;
            <br />
            （3）任何因黑客攻击、电脑病毒侵入及其他不可抗力事件导致信息的泄露。
          </div>
          <div>2、本保密条款在本合同期满、解除或终止后仍然有效</div>
          <p className="agreement-sub-title">七．履约说明</p>
          <div className="agreement-main-text">
            软件实际使用人与甲方不一致的，甲方应向乙方说明软件的实际使用人，由乙方向其提供服务。
          </div>
          <p className="agreement-sub-title">八．不可抗力</p>
          <div className="agreement-main-text">
            遭受不可抗力事件的一方（该事件包括但不限于政府行为、自然灾害、战争、黑客袭击或其它类似事件）可暂行中止履行本合同项下的义务直至不可抗力事件的影响消除为止，并且无需为此承担违约责任；但应书面通知对方遭遇不可抗力的情况并尽最大努力克服该事件，减轻其负面影响。
          </div>
          <p className="agreement-sub-title">九．合同解除与违约责任</p>
          <div className="agreement-main-text">
            1、若甲方存在合同内包括侵犯知识产权、违反保密条款或违反网络产品使用原则等行为，乙方有权解除合同；若“互动班课”技术服务无法使用或乙方无合理理由拒绝维护程序或提供必要指导的，甲方有权解除合同。
          </div>
          <div className="agreement-main-text">
            2、解除合同的一方可以向违约方主张损失。但解除合同的一方有将自身损失控制在最小的义务。
          </div>
          <p className="agreement-sub-title">十、争议处理</p>
          <div className="agreement-main-text">
            由本合同引起的或与本合同有关的任何争议，由双方友好协商解决。协商不成，双方同意提交乙方住所地有管辖权的人民法院诉讼解决。
          </div>
          <p className="agreement-sub-title">十一、合同有效期及合同变更</p>
          <div className="agreement-main-text">
            1、本合同有效期自双方签署之日起算，至“互动班课”充值账户到期日为止，甲方在合同有效期内方可按约定使用“互动班课”技术服务。
          </div>
          <div className="agreement-main-text">
            2、本合同到期后将自动终止，若需延期，双方应按照乙方届时的费用标准另行签订协议。
          </div>
          <div className="agreement-main-text">
            3、对本合同条款所做的任何变更以及其他未尽事宜，均须由双方协商解决，为此所形成的书面文件或补充附件等，与本合同具有同等法律效力
          </div>
          <p className="agreement-sub-title">十二．附加说明</p>
          <div className="agreement-main-text">
            1，甲乙双方所有权利义务都以本协议约定为准，乙方委派的销售人员如有与本协议内容不符的任何承诺均不代表乙方的真实意图和承诺。
          </div>
          <div className="agreement-main-text">
            2，除本协议条款二第1,2,4条允许手写（仅限于条款规定的日期，价格，版本与名称等相关内容）外，其他位置均以打印字体为准。
          </div>
        </div>
      </Modal>
    );
  }
}

export default ChargeArgeement;
