/*
 * @Author: 吴文洁
 * @Date: 2020-07-23 14:54:16
 * @LastEditors: zhangleyuan
 * @LastEditTime: 2020-12-24 10:23:44
 * @Description: 大班直播课预览弹窗
 * @Copyright: 杭州杰竞科技有限公司 版权所有
 */ 

import React from 'react';
import { Modal } from 'antd';
import moment from 'moment';
import './PreviewCourseModal.less';

const courseStateShow = {
  UN_START: {
    title: "待开课",
  },
  STARTING: {
    title: "上课中",
  },
  FINISH: {
    title: "已完成",
  },
  EXPIRED: {
    code: 4,
    title: "未成功开课",
    color: "#CCCCCC",
  },
};
class PreviewCourseModal extends React.Component {

  constructor(props) {
    super(props);
    this.state = {

    }
  }

  dealWithTime = (startTime, endTime) => {
  const startDate = new Date(Number(startTime));
  const endDate = new Date(Number(endTime));

  const year = startDate.getFullYear();
  const month = (startDate.getMonth() + 1) < 10 ? `0${startDate.getMonth() + 1}` : startDate.getMonth() + 1;
  const day = startDate.getDate() < 10 ? `0${startDate.getDate()}` :  startDate.getDate();

  const startHour = startDate.getHours() < 10 ? `0${startDate.getHours()}` : startDate.getHours();
  const startMinute = startDate.getMinutes() < 10 ? `0${startDate.getMinutes()}` : startDate.getMinutes();

  const endHour = endDate.getHours() < 10 ? `0${endDate.getHours()}` : endDate.getHours();
  const endMinute = endDate.getMinutes() < 10 ? `0${endDate.getMinutes()}` : endDate.getMinutes();

  const liveDateStr = `${year}-${month}-${day}`;
  const startTimeStr = `${startHour}:${startMinute}`;
  const endTimeStr = `${endHour}:${endMinute}`;

  return {
    liveDateStr,
    startTimeStr,
    endTimeStr,
  };
}


  render() {
    const { courseBasicInfo, courseClassInfo = {}, courseIntroInfo, type,courseState} = this.props;
    const { coverUrl, courseName, scheduleVideoUrl } = courseBasicInfo;
    const { liveDate, calendarTime,startTime,endTime,timeHorizonStart, timeHorizonEnd, teacherName } = courseClassInfo;
    const { liveCourseMediaRequests } = courseIntroInfo;

    let liveDateStr, startTimeStr, endTimeStr;
    
    if (type === 'add') {
      const _liveDate = moment(calendarTime[0]).format("YYYY-MM-DD");
      console.log("_liveDate",_liveDate);
      const _timeHorizonStart = moment(startTime).format('HH:mm');
      const _timeHorizonEnd = moment(endTime).format('HH:mm');
      const _startTime = moment(_liveDate + ' ' + _timeHorizonStart).format('x');
      const _endTime = moment(_liveDate + ' ' + _timeHorizonEnd).format('x');
      const {
        liveDateStr: _liveDateStr,
        startTimeStr: _startTimeStr,
        endTimeStr: _endTimeStr
      } = this.dealWithTime(_startTime, _endTime);

      liveDateStr = _liveDateStr;
      startTimeStr = _startTimeStr;
      endTimeStr = _endTimeStr;
    }else{
      const _liveDate = moment(liveDate).format("YYYY-MM-DD");
      const _timeHorizonStart = moment(timeHorizonStart).format('HH:mm');
      const _timeHorizonEnd = moment(timeHorizonEnd).format('HH:mm');
      const startTime = moment(_liveDate + ' ' + _timeHorizonStart).format('x');
      const endTime = moment(_liveDate + ' ' + _timeHorizonEnd).format('x');
      const {
        liveDateStr: _liveDateStr,
        startTimeStr: _startTimeStr,
        endTimeStr: _endTimeStr
      } = this.dealWithTime(startTime, endTime);

      liveDateStr = _liveDateStr;
      startTimeStr = _startTimeStr;
      endTimeStr = _endTimeStr;
    }

    return (
      <Modal
        title="预览"
        visible={true}
        width={680}
        onCancel={this.props.close}
        footer={null}
        maskClosable={false}
        className="preview-live-course-modal"
      >
        <div className="container__wrap">
          <div className="container">
            <div className="container__header">
              {
                type === 'videoCourse' ?
                <video
                  controls
                  src={scheduleVideoUrl}
                  poster={coverUrl ? coverUrl : `${scheduleVideoUrl}?x-oss-process=video/snapshot,t_0,m_fast`}
                  className="course-url"
                /> :
                <img src={coverUrl} className="course-cover" />
              }
            </div>

            {
              type === 'videoCourse' ?
              <div className="container__body">
                <div className="title__name">{courseName}</div>
                <div className="title__inst-name">{window.currentUserInstInfo.name}</div>
              </div> :
              <div className="container__body">
                <div className="container__body__title">
                  <div className="title__name">{courseName}</div>
                  <div className="title__state">{courseStateShow[courseState].title}</div>
                </div>
                <div className="container__body__time">
                  <span className="time__label">上课时间：</span>
                  <span className="time__value">
                    {
                     
                      [
                        <span>{liveDateStr}&nbsp;</span>,
                        <span>{startTimeStr}~{endTimeStr }</span>
                      ]
                    }
                    
                  </span>
                </div>
                <div className="container__body__teacher">
                  <span className="teacher__label">上课老师：</span>
                  <span className="teacher__value">{teacherName}</span>
                </div>
              </div>
            }
            
            <div className="container__introduction">
              <div className="container__introduction__title">直播简介</div>
              <div className="container__introduction__list editor-box">
                {
                  liveCourseMediaRequests.map((item, index) => {
                    if (item.mediaType === 'TEXT') {
                      return (
                        <div
                          className="intro-item text"
                          dangerouslySetInnerHTML={{
                            __html: item.mediaContent
                          }}
                        />
                      )
                    }

                    if (item.mediaType === 'PICTURE') {
                      return (
                        <div className="intro-item picture">
                          <img src={item.mediaUrl}  />
                        </div>
                      )
                    }
                  })
                }
              </div>
            </div>
          </div>
        </div>
      </Modal>
    )
  }
}

export default PreviewCourseModal;
