import React from 'react';
import E from 'wangeditor';
import './GraphicsEditor.less';



class GraphicsEditor extends React.Component {
  constructor(props) {
    super(props)
    this.state = {
      editorId: window.random_string(16),
      textLength: 0,
    }
  }

  componentDidMount() {
    this.renderEditor()
    this.resetIndex(true);
  }

  componentWillUnmount() {
    this.resetIndex();
  }

  resetIndex = (bool) => {
    const topDom = document.querySelector('.top-container');
    const leftDom = document.querySelector('.left-container');
    topDom.style.zIndex = bool ? 'auto' : 112;
    leftDom.style.zIndex = bool ? 'auto' : 2;
  }

  renderEditor() {
    const { editorId } = this.state;
    const { detail, onChange, isIntro } = this.props;
    const editorInt = new E(`#editor${editorId}`);
    editorInt.config.showFullScreen = !isIntro
    editorInt.config.menus = isIntro ?
      [
        'head',
        'bold',
        'fontSize',
        'fontName',
        'italic',
        'underline',
        'strikeThrough',
        'foreColor',
        'backColor',
        'list',
        'justify',
        'emoticon',
        'image',
      ]
      : [
        'head',
        'bold',
        'fontSize',
        'fontName',
        'italic',
        'underline',
        'strikeThrough',
        'indent',
        'lineHeight',
        'foreColor',
        'backColor',
        'link',
        'list',
        'todo',
        'justify',
        'quote',
        'emoticon',
        'image',
        'video',
        'table',
        'code',
        'splitLine',
        'undo',
        'redo',
      ];

    editorInt.config.emotions = [
      {
        title: 'emoji',
        type: 'emoji',
        content: ['😀', '😃', '😄', '😁', '😆', '😅', '😂', '😊', '🙂', '🙃', '😉', '😓', '😅', '😪', '🤔', '😬', '🤐']
      }
    ]
    editorInt.config.zIndex = 1;
    editorInt.config.pasteFilterStyle = false;
    editorInt.config.pasteIgnoreImg = true;
    // 自定义处理粘贴的文本内容
    editorInt.config.pasteTextHandle = function (content) {
      if (content == '' && !content) return ''
      var str = content
      str = str.replace(/<xml>[\s\S]*?<\/xml>/ig, '')
      str = str.replace(/<style>[\s\S]*?<\/style>/ig, '')
      str = str.replace(/[ | ]*\n/g, '\n')
      str = str.replace(/\&nbsp\;/ig, ' ')
      return str
    }
    editorInt.config.onchange = (html) => {
      const textLength = editorInt.txt.text().replace(/\&nbsp\;/ig, ' ').length;
      this.setState({ textLength }, () => {
        onChange(html, this.state.textLength);
      })
    }
    editorInt.create();
    editorInt.txt.html(detail.content);
  }

  render() {
    const { editorId, textLength } = this.state;
    const { limitLength = 1000 } = this.props;

    return <div className="wang-editor-container ">
      <div className="editor-box" id={`editor${editorId}`}></div>
      {textLength > limitLength && <div className="editor-tips">超了{textLength - limitLength}个字</div>}
    </div>
  }
}

export default GraphicsEditor;
