/*
 * @Author: wufan
 * @Date: 2020-11-30 10:47:38
 * @LastEditors: Please set LastEditors
 * @LastEditTime: 2021-08-11 20:31:26
 * @Description: 学员管理页面
 * @@Copyrigh: © 2020 杭州杰竞科技有限公司 版权所有
 */

import React, { useEffect, useState } from "react";
import { Route,withRouter } from "react-router-dom";
import StoreService from "@/domains/store-domain/storeService";
import _ from "underscore";
import User from "@/common/js/user";
import {Tabs,Badge} from "antd";
import DepartMentTabCon from './components/DepartMentTabCon';
import WechatUserAudit from './WechatUserAudit/WechatUserAudit'

import "./NewUsersManagePage.less";

const { TabPane } = Tabs;


function UserManagePage(props) {
  const { match } = props;
  const [currentTab, setCurrentTab] = useState("departMentTab");
  const [auditSwitch,setAuditSwitch] = useState('No') 
  const [listCount, setListCount] = useState({
    "allCnt": 0,
    "passedCnt": 0,
    "rejectedCnt": 0,
    "waitCnt": 0
  });
  useEffect(()=>{
    //列表获取
    function handleFetchAuditListCount(_query) {
      const params = {
        storeId: User.getStoreId(),
      };
    
      StoreService.getCustomerAuditListCount(params).then((res) => {
        const {
          result,
        } = res;
        setListCount(result)
      });
    }
    handleFetchAuditListCount();
  },[])

  function getStoreDetail(){
    const params= {
      storeId:User.getStoreId()
    }
    return StoreService.getStoreDetail(params).then((res) => {
      const { result = { } } = res;
      const {
        auditSwitch
      } = result;
      setAuditSwitch(auditSwitch)
      return auditSwitch
    })
  }
  function jumpWechatAudit(){
    getStoreDetail().then((res)=>{
      if(res === 'OPEN'){
        window.RCHistory.push({
          pathname: `${match.url}/wechat-user-audit`,
        });
      }
    })
  }

  useEffect(()=>{
    getStoreDetail()
  },[])
  return (
    <div className="page new-user-manage-page">
        <div className="content-header">
          <div>学员管理</div>
            <If condition={auditSwitch === 'OPEN'}>
              <div className='wechat-audit' onClick={jumpWechatAudit} >
                <div>
                  <span className='icon iconfont icon-font-weixin'>&#xe8e0;</span>
                  <span className='content-header-right'>学员审核列表</span>
                </div>
                <If condition={listCount.waitCnt!=='0'}>
                  <Badge status="error" text="" offset={[6,-6]} />
                </If>
              </div>
             
            </If>
        </div>
        <div className="box">
          <div className="tab-box">
            <Tabs
              onChange={(key) => {
                setCurrentTab(key);
              }}
              activeKey={currentTab}
            >
              <TabPane key="departMentTab" tab="部门"></TabPane>
              <TabPane key="postGrouptab" tab="岗位组"></TabPane>
              <TabPane key="customGroupTab" tab="自定义分组"></TabPane>
            </Tabs>
          </div>
          <div className="box-body tab-con">
            <DepartMentTabCon currentTab={currentTab}/>
          </div>
        </div>
        <Route
          path={`${match.url}/wechat-user-audit`}
          render={() => {
            return <WechatUserAudit/>;
          }}
        />
    </div>
  );
}

export default withRouter(UserManagePage);
