/*
 * @Author: yuananting
 * @Date: 2021-08-12 18:08:59
 * @LastEditors: yuananting
 * @LastEditTime: 2021-08-12 18:17:19
 * @Description: 描述一下咯
 * @Copyrigh: © 2020 杭州杰竞科技有限公司 版权所有
 * @@Copyrigh: © 2020 杭州杰竞科技有限公司 版权所有
 */
import React from 'react';
import { Progress, Space } from 'antd';
import ENUM from '../../enum';

function CustomerLearnBasicInfo(props) {
  return (
    <div className='header'>
      <div className='train-title'>{props.detail.taskName}</div>
      <div className='data-info'>
        <div className='user-name'>学员：{props.detail.storeCustomerName}</div>
        <div className='complete-progress'>
          任务完成率：
          <div style={{ width: 120 }}>
            <Progress size={120} strokeColor='#2966FF' trailColor='#EAEAEA' percent={props.detail.learnFinishPercentage} size='small' />
          </div>
        </div>
        <Space size={24}>
          <div>
            <img src={ENUM.LearningContentIcon['COURSE']} />
            课程：{props.detail.courseFinishNum || 0}/{props.detail.courseAllNum || 0}
          </div>
          <div>
            <img src={ENUM.LearningContentIcon['EXAM']} />
            考试：{props.detail.examFinishNum || 0}/{props.detail.examAllNum || 0}
          </div>
        </Space>
      </div>
    </div>
  );
}

export default CustomerLearnBasicInfo;
