/*
 * @Author: 吴文洁
 * @Date: 2020-07-20 19:12:49
 * @Last Modified by: 吴文洁
 * @Last Modified time: 2020-07-20 20:25:13
 * @Description: 大班直播分享弹窗
 */

import React from 'react';
import { Modal, Button, message } from 'antd';
import domtoimage from 'dom-to-image';
import qrcode from '@/libs/qrcode/qrcode.js';
import User from '@/common/js/user';
import $ from 'jquery';
import CourseService from '@/domains/course-domain/CourseService';

import './ShareTrainTaskModal.less';

const DEFAULT_COVER = 'https://image.xiaomaiketang.com/xm/rEAetaTEh3.png';

class ShareTrainTaskModal extends React.Component {
  constructor(props) {
    super(props);

    this.state = {
      shareUrl: '',
    };
  }

  componentDidMount() {
    // 获取短链接
    this.handleConvertShortUrl();
  }

  handleConvertShortUrl = () => {
    const { longUrl } = this.props.data;
    // 发请求
    CourseService.getQrcode({
      urls: [longUrl],
    }).then((res) => {
      const { result = [] } = res;

      this.setState(
        {
          shareUrl: result[0].shortUrl,
        },
        () => {
          const qrcodeWrapDom = document.querySelector('#qrcodeWrap');
          const qrcodeNode = new qrcode({
            text: this.state.shareUrl,
            size: 98,
          });
          qrcodeWrapDom.appendChild(qrcodeNode);

          const qrcodeWrapDomDownload = document.querySelector('#qrcodeWrap-dowload');
          const qrcodeNodeDownLoad = new qrcode({
            text: this.state.shareUrl,
            size: 196,
          });
          qrcodeWrapDomDownload.appendChild(qrcodeNodeDownLoad);
        }
      );
    });
  };

  componentWillUnmount() {
    // 页面销毁之前清空定时器
    clearTimeout(this.timer);
  }

  // 下载海报
  handleDownloadPoster = () => {
    this.setState(
      {
        showImg: true,
        time: new Date().valueOf(),
      },
      () => {
        this.setState({ time: new Date().valueOf() }, () => {
          let node = document.getElementById('poster-dowload');
          domtoimage.toPng(node).then((imgData) => {
            const download = document.createElement('a');
            const { planName } = this.props.data;
            $(download).attr('href', imgData).attr('download', `${planName}.png`).get(0).click();
          });
        });
      }
    );
  };

  // 复制分享链接
  handleCopy = () => {
    const textContent = document.getElementById('shareUrl').innerText;

    window.copyText(textContent);
    message.success('复制成功!');
  };

  render() {
    const { data } = this.props;
    const { planName, coverUrl = DEFAULT_COVER } = data;
    const { shareUrl, showImg, time } = this.state;
    return (
      <Modal
        title={'分享培训任务'}
        width={680}
        visible={true}
        footer={null}
        maskClosable={false}
        closeIcon={<span className='icon iconfont modal-close-icon'>&#xe6ef;</span>}
        className='share-task-modal'
        onCancel={this.props.close}>
        <div className='left'>
          <div id='poster'>
            <div className='store-name'>
              <span className='text'>{User.getStoreName()}</span>
            </div>

            <div className='course-name-title'>邀请你参与培训：</div>

            <div className='live-couse-name'>{planName}</div>
            <Choose>
              <When condition={showImg}>
                <img crossOrigin='*' src={coverUrl + `?=${time}`} className='course-cover' alt='' />
              </When>
              <Otherwise>
                <img src={coverUrl + `?=${time}`} className='course-cover' alt='' />
              </Otherwise>
            </Choose>

            <div className='qrcode-wrap'>
              <div className='qrcode-wrap__left'>
                <div className='text'>长按识别二维码进入观看</div>
                <img className='finger' src='https://image.xiaomaiketang.com/xm/thpkWDwJsC.png' alt='' />
              </div>
              <div className='qrcode-wrap__right' id='qrcodeWrap'></div>
            </div>
          </div>
          <div id='poster-dowload'>
            <div className='store-name'>
              <span className='text'>{User.getStoreName()}</span>
            </div>

            <div className='course-name-title'>邀请你参与培训：</div>

            <div className='live-couse-name'>{planName}</div>
            <Choose>
              <When condition={showImg}>
                <img crossOrigin='*' src={coverUrl + `?=${time}`} className='course-cover' alt='' />
              </When>
              <Otherwise>
                <img src={coverUrl + `?=${time}`} className='course-cover' alt='' />
              </Otherwise>
            </Choose>

            <div className='qrcode-wrap'>
              <div className='qrcode-wrap__left'>
                <div className='text'>长按识别二维码进入观看</div>
                <img className='finger' src='https://image.xiaomaiketang.com/xm/thpkWDwJsC.png' alt='' />
              </div>
              <div className='qrcode-wrap__right' id='qrcodeWrap-dowload'></div>
            </div>
          </div>
        </div>
        <div className='right'>
          <div className='share-poster right__item'>
            <div className='title'>① 海报分享</div>
            <div className='sub-title'>学员可通过微信扫描海报二维码，查看培训计划</div>
            <div className='content' onClick={this.handleDownloadPoster}>
              下载海报
            </div>
          </div>

          <div className='share-url right__item'>
            <div className='title'>② 链接分享</div>
            <div className='sub-title'>学员可通过微信或浏览器打开以下链接，查看培训计划</div>
            <div className='content url-content'>
              <div className='share-url' id='shareUrl'>
                {shareUrl}
              </div>
              <Button type='primary' onClick={this.handleCopy}>
                复制
              </Button>
            </div>
          </div>
        </div>
      </Modal>
    );
  }
}

export default ShareTrainTaskModal;
