/*
 * @Author: wufan
 * @Date: 2020-07-09 14:03:09
 * @Last Modified by: mikey.zhaopeng
 * @Last Modified time: 2020-11-28 13:53:12
 * 店铺管理-员工管理
 */
import React, { useEffect, useState } from "react";
import { withRouter } from "react-router-dom";
import _ from "underscore";
import PageControl from "@/components/PageControl";
import { Button, Table,Modal,message} from "antd";
import { QuestionCircleOutlined } from '@ant-design/icons';
import StoreService from "@/domains/store-domain/storeService";
import CatalogAddOrEditModal from './modal/CatalogAddOrEditModal';
import SecondCatalogAddOrEditModal from './modal/SecondCatalogAddOrEditModal';
import "./CourseCatalogPage.less";
import User from '@/common/js/user';
const { confirm } = Modal;
interface RecordTypes {
  child: any;
}

function CourseCatalogPage() {
  const [courseCatalogList, setCourseCatalogList] = useState([]);

  const [query, setQuery] = useState({
    current: 0,
    size: 10,
    storeId: User.getStoreId(),
  });
  
  const [total, setTotal] = useState(0);
  const [catalogModalVisible,setCatalogModalVisible] = useState(false);
  const [catalogModalType,setCatalogModalType] = useState('');
  const [secondCatalogModalVisible,setSecondCatalogModalVisible] = useState(false);
  const [secondCatalogModalType,setSecondCatalogModalType] = useState('');
  const [parentCatalogId,setParentCatalogId] = useState('');
  const [choosedItem, setChooseItem] = useState({});
  useEffect(() => {
    getCourseCatalogList();
  }, [query]);

  function addCatalog(){
    setChooseItem({});
    setCatalogModalVisible(true) ;
    setCatalogModalType('add');
  }
  function addSecondCatalog(record:any){
    setChooseItem({});
    setParentCatalogId(record.id);
    setSecondCatalogModalVisible(true);
    setSecondCatalogModalType('add');
  }
  function deleteCatalog(record:any){
    return  confirm({
      title: record.type==='parent'? '你确定要删除此分类吗？':'你确定要删除此子分类吗？',
      content: record.type==='parent'? '删除后，此分类下包含的所有子分类都会被删除，此操作不可恢复。':'此操作不可恢复。',
      icon: <QuestionCircleOutlined />,
      okText: '删除',
      okType: 'danger',
      cancelText: '取消',
      onOk: () => {
        handleDeleteCatalog(record);
      }
    })
  }

  function handleDeleteCatalog(record:any) {
    const param ={
      categoryId:record.id
    }
    StoreService.delCourseCategory(param).then((res: any) =>{
      if(record.type ==='parent'){
        let  _courseCatalogList:any = [...courseCatalogList];
        for(let i=0;i<_courseCatalogList.length;i++){
          if(_courseCatalogList[i].id === record.id){
            _courseCatalogList.splice(i,1);
          }
        }
        setCourseCatalogList(_courseCatalogList)
      }else{
        let  _courseCatalogListClone:any = JSON.parse(JSON.stringify(courseCatalogList));
        for(let i=0;i<_courseCatalogListClone.length;i++){
          if(_courseCatalogListClone[i].child){
            for(let j=0;j<_courseCatalogListClone[i].child.length;j++){
              if(_courseCatalogListClone[i].child[j].id === record.id){
                _courseCatalogListClone[i].child.splice(j,1);
              }
            }
          }
        }
        setCourseCatalogList(_courseCatalogListClone)
      }
     
      message.success("分类已删除");
    });
  }
  function parseColumn():any{
    return [
        { title: '分类名称', 
          dataIndex: 'categoryName', 
          key: 'categoryName',
        },
        {
          title: '操作',
          dataIndex: 'action',
          key: 'action',
          width:300,
          render: (val: string, record: any) => {
            return (
              <div className="operation">
                  { record.type==="parent" && 
                    <>
                      <span
                        className="add"
                        onClick={() => { addSecondCatalog(record) }}
                      >
                        添加子分类
                      </span>
                      <span className="divider-line">{" | "}</span>
                    </>
                  }
                 
                  <span
                    onClick={()=>{editCatalog(record)}}
                  >    
                  编辑
                  </span>
                  <span className="divider-line" >{" | "}</span>
                  <span   onClick={()=>{deleteCatalog(record)}}
                  >
                    删除
                  </span>
            </div>
            )

          },
        },
    ]
  }
  function getCourseCatalogList():any {
    let _query = _.clone(query);
    _query.current = query.current + 1;
    StoreService.getCourseCatalogList(_query).then((res: any) => {
      let resultData = handleCatalogListData(res.result.records)
      setCourseCatalogList(resultData);
      console.log("res",resultData);
      setTotal(res.result.total);
    });
  }
  function refreshCatalogList(data:any):any{
    let  _courseCatalogList:any = [...courseCatalogList];
    const { type} = data;
    switch (type){
      case 'addCatalog':
        const item = {
          categoryName:data.catalogName,
          id:data.id,
          hasSon:false,
          key:data.id,
          type:'parent'
        }
        _courseCatalogList.push(item);
        setCourseCatalogList(_courseCatalogList)
      break;
      case 'editCatalog':   
        _courseCatalogList.map((item:any,index:any)=>{
          if(item.id === data.id){
            item.categoryName = data.catalogName
          }
          return item
        });
        setCourseCatalogList(_courseCatalogList)
      break;
      case 'addSecondCatalog':  
          const secondItem = {
            categoryName:data.catalogName,
            id:data.id,
            key:data.id
          }
          let  _courseCatalogListClone:any = JSON.parse(JSON.stringify(courseCatalogList));
          _courseCatalogListClone.map((item:any,index:any)=>{
            if(item.id === data.parentId){
              if(!item.child){
                item.child=[];
              }
              item.child.push(secondItem)
            }
            return item
          });
          setCourseCatalogList(_courseCatalogListClone)
      break;
      case 'editSecondCatalog':
        const secondEditItem = {
          categoryName:data.catalogName,
          id:data.id,
          key:data.id
        }
        let  _courseCatalogListEditClone:any = JSON.parse(JSON.stringify(courseCatalogList));
        _courseCatalogListEditClone.map((item:any,index:any)=>{
          if(item.id === data.parentId){
             if(item.child){
              item.child.map((_item:any,_index:any)=>{
                if(_item.id === data.id){
                  _item.categoryName =data.catalogName;
                }
              })
             }  
            
          }
          return item
        });
      break;
      default:
      break;
    }
  }

  function handleCatalogListData(listData:any){
    listData.map((item:any,index:any) => {
      item.type = "parent"
      item.key = item.id;
      item.child = [];
      return item
    })
    
     return listData
  }

  function editCatalog(record:any){
    if(record.type ==="parent"){
      setCatalogModalType('edit');
      setCatalogModalVisible(true);
    }else{
      setSecondCatalogModalType('edit');
      setSecondCatalogModalVisible(true);
    }
    setChooseItem(record);
  }
  function expandSecondCatalog(expanded:boolean,record:any){
    const parentId = record.id;
    const param = {
      parentId,
    }
    StoreService.getAllSonCategory(param).then((res: any) => {
      record.child= res.result || [];
      record.child.map((item:any,index:any) => {
        item.key= item.id
        return item
      })
      const _courseCatalogList =[...courseCatalogList];
      setCourseCatalogList(_courseCatalogList)
    });
  }
  

  return (
    <div className=" page course-catalog-page">
      <div className="page-content">
        <div className="content-header">员工管理</div>
        <div className="box">
          <div className="box-header">
            <Button
              type="primary"
              className="add-show-btn"
              onClick={() => {addCatalog()}}
            >
              添加分类
            </Button>
          </div>
          <div className="box-body">
            <Table
                columns={ parseColumn() }
                pagination={false}
                expandedRowRender={(record:RecordTypes) => {
                  if(!record.child){
                    return
                  }
                  if (record.child.length !== 0){
                    console.log("record.child",record.child);
                    return <Table columns={parseColumn()} dataSource={record.child} pagination={false}   className="child-table"/>
                    // return <div>{
                    //     record.child.map((item:any,index:any)=>{
                    //       return <span>{item.categoryName}</span>
                    //     })
                    //   }
                    // </div>
                  }else{
                    return <div>还未添加任何子分类</div>;
                  }
                }}
                dataSource={courseCatalogList}
                onExpand={(expanded, record)=>expandSecondCatalog(expanded, record)}
            />
          </div>
          <div className="box-footer">
            <PageControl
               current={query.current}
               pageSize={query.size}
               total={total}
               toPage={(page: any) => {
                 const queryStates = _.clone(query);
                 queryStates.current = page;
                 setQuery(queryStates);
               }}
              
            />
          </div>
        </div>
        {
          catalogModalVisible && <CatalogAddOrEditModal modalType={catalogModalType} onClose={()=>{setCatalogModalVisible(false)}} refreshCatalogList={refreshCatalogList} choosedItem={choosedItem}/>
        }
        {
          secondCatalogModalVisible && <SecondCatalogAddOrEditModal modalType={secondCatalogModalType} parentId={parentCatalogId} onClose={()=>{setSecondCatalogModalVisible(false)}} choosedItem={choosedItem} refreshCatalogList={refreshCatalogList} />
        }
      </div>
    </div>
  );
}

export default withRouter(CourseCatalogPage);
