import React, { useEffect, useState } from 'react';
import { withRouter } from 'react-router-dom';
import './Login.less';
import User from '@/common/js/user';
import WechatLogin from './WechatLogin';
import BaseService from '@/domains/basic-domain/baseService';
import storage from '@/common/js/storage';
import _ from 'underscore';
import user from '@/common/js/user';

function Login() {
  useEffect(() => {
    const enterpriseId = getParameterByName('enterpriseId');
    const userId = getParameterByName('userId');
    const from = getParameterByName('from');
    const storeId = getParameterByName('storeId');
    if (storeId) {
      User.setCustomerStoreId(storeId);
    }
    if (from === 'customer' && enterpriseId && userId) {
      if (!user.getToken() || enterpriseId !== user.getEnterpriseId() || userId !== User.getUserId()) {
        getWXWorkLoginNoCheck(enterpriseId, userId);
      } else {
        window.RCHistory.push({
          pathname: `/switch-route`,
        });
      }
    } else {
      User.removeUserId();
      User.removeToken();
      User.removeEnterpriseId();
    }
    storage.set('expiration_tip_login', true);
  }, []);
  function getWXWorkLoginNoCheck(enterpriseId, userId) {
    const params = {
      appTermEnum: 'XIAOMAI_CLOUD_CLASS_PC_WEB_ADMIN',
      enterpriseId,
      userId,
    };
    BaseService.getWXWorkLoginNoCheck(params).then((res) => {
      User.setUserId(res.result.loginInfo.userId);
      User.setToken(res.result.loginInfo.xmToken);
      User.setEnterpriseId(res.result.enterpriseId);
      User.setIdentifier(res.result.identifier);
      window.RCHistory.push({
        pathname: `/switch-route`,
      });
    });
  }

  return (
    <div className='login-page'>
      <div className='logo-img-box'>
        <img src='https://image.xiaomaiketang.com/xm/6k8PPCmywG.png' className='logo-img' />
      </div>
      <div className='login-main'>
        <div className='left-banner'>
          <div className='img-box'>
            <img src='https://image.xiaomaiketang.com/xm/zmsfCP4e5i.png' alt='' />
          </div>
        </div>
        <div className='login-box'>
          <img className='login-logo' src='https://image.xiaomaiketang.com/xm/PrxzFpFH7C.png'></img>
          <h3>小麦企培（讲师版）</h3>
          <h4>企业微信登陆</h4>
          <WechatLogin></WechatLogin>
        </div>
      </div>
    </div>
  );
}

export default withRouter(Login);
