/*
 * @Author: yuananting
 * @Date: 2021-07-05 10:50:30
 * @LastEditors: yuananting
 * @LastEditTime: 2021-07-14 14:32:55
 * @Description: 描述一下咯
 * @Copyrigh: © 2020 杭州杰竞科技有限公司 版权所有
 * @@Copyrigh: © 2020 杭州杰竞科技有限公司 版权所有
 */
import React from 'react';
import { Table, Modal, Input } from 'antd';
import PlanService from '@/domains/plan-domain/planService';
import User from '@/common/js/user';
import './UserLearnDetailModal.less';
import _ from 'underscore';
import { FileTypeIcon } from '@/common/constants/academic/lessonEnum'
const defaultCover = 'https://image.xiaomaiketang.com/xm/rEAetaTEh3.png';
const CourseType = {
  LIVE: {
    text: '直播课',
  },
  VOICE: {
    text: '线上课',
  },
  RECORD: {
    text: '录播课',
  },
  PICTURE: {
    text: '图文课',
  },
};
const courseStateShow = {
  UN_START: {
    title: '待开播',
  },
  STARTING: {
    title: '直播中',
  },
  FINISH: {
    title: '回放',
  },
  EXPIRED: {
    title: '未成功开课',
  },
};
class UserLearnDetailModal extends React.Component {
  constructor(props) {
    super(props);
    this.state = {
      planDataSource: {},
      taskDataSource: [],
      taskSize: 10,
      taskQuery: {
        current: 1,
      },
      taskTotalCount: 0,
      courseDataSource: [],
      storeCustomerName: '',
      storeCustomerPhone: '',
    };
  }
  componentDidMount() {
    this.getPlanCustomerDetail();
  }
  getPlanCustomerDetail = () => {
    PlanService.getPlanCustomerDetail({
      planId: getParameterByName('id'),
      storeCustomerId: this.props.storeCustomerId,
      storeId: User.getStoreId(),
    }).then((res) => {
      const { storeCustomerName, storeCustomerPhone, planName, learnFinishPercentage, taskCustomerVOList, courseMediaVOS } = res.result;
      let coverUrl;
      courseMediaVOS.map((item) => {
        if (item.contentType === 'COVER') {
          coverUrl = item.mediaUrl;
        }
        return item;
      });
      const planDataSource = {
        planName,
        learnFinishPercentage,
        coverUrl: coverUrl || defaultCover,
      };
      this.setState({
        storeCustomerName,
        storeCustomerPhone,
        planDataSource,
        taskDataSource: taskCustomerVOList,
      });
    });
  };

  parsePlanDataColumns = () => {
    const columns = [
      {
        title: '培训计划名称',
        key: 'planName',
        dataIndex: 'planName',
        width: '77%',
        render: (val, record, index) => {
          return (
            <div className='record-name'>
              <div className='img-con'>
                <img src={record.coverUrl} />
              </div>
              <div>{record.planName}</div>
            </div>
          );
        },
      },
      {
        title: '学习进度',
        key: 'learnFinishPercentage',
        dataIndex: 'learnFinishPercentage',
        render: (val, record, index) => {
          return <div>{val}%</div>;
        },
      },
    ];
    return columns;
  };

  parseTaskColumns = () => {
    const columns = [
      {
        title: '培训任务',
        key: 'taskName',
        dataIndex: 'taskName',
        width: '68%',
        render: (val, record, index) => {
          return (
            <div className='taskName'>
              {index + 1}.{record.taskName}
            </div>
          );
        },
      },
      {
        title: '学习进度',
        key: 'learnFinishPercentage',
        dataIndex: 'learnFinishPercentage',
        render: (val, record) => {
          return <div className='task-learn-percentage'>{val === 100 ? <span>已完成</span> : <span>{val}%</span>}</div>;
        },
      },
    ];
    return columns;
  };

  parseCourseColumns = (parentIndex) => {
    const columns = [
      {
        title: '课程',
        key: 'courseName',
        dataIndex: 'courseName',
        width: '70%',
        render: (val, record, index) => {
          return (
            <div className='course-info'>
              <div>
                <span className='course-type'>{CourseType[record.courseType].text}</span>
                <span>
                  {parentIndex + 1}.{index + 1}&nbsp;
                </span>
              </div>
              <div className='name-and-state'>
                <span className='course-name'>{record.courseName}</span>
                {record.courseType === 'LIVE' && <span className='course-state'>{courseStateShow[record.courseState].title}</span>}
              </div>
            </div>
          );
        },
      },
      {
        title: '学习进度',
        key: 'learnFinishPercentage',
        dataIndex: 'learnFinishPercentage',
        render: (val, record) => {
          return <div className='course-learn-percentage'>{record.learnState === 'FINISH' ? <span>已完成</span> : <span>{val}%</span>}</div>;
        },
      },
    ];
    return columns;
  };

  parseChapterColumns = (chapterIndex) => {
    const columns = [
      {
        title: '课节名称',
        key: 'name',
        dataIndex: 'name',
        width: '80%',
        render: (val, record, index) => {
          return (
            <div className='chapter-record'>
              <span>
                {index < 9 ? `0${index + 1} ` : index + 1}
              </span>
              <img className='chapter-img' src={FileTypeIcon[record.mediaType]} />
              <span className='chapter-name'>{record.name}</span>
            </div>
          );
        },
      },
      {
        title: '学习进度',
        key: 'watchProgress',
        dataIndex: 'watchProgress',
        render: (val, record) => {
          return <span>{val}%</span>;
        },
      },
    ];
    return columns;
  };

  render() {
    const { storeCustomerName, storeCustomerPhone, planDataSource, taskDataSource, taskQuery, taskTotalCount } = this.state;
    const { visible } = this.props;
    return (
      <Modal
        title='学员学习详情'
        onCancel={this.props.onClose}
        onOk={this.props.onClose}
        maskClosable={false}
        visible={visible}
        className='user-Learn-modal'
        closable={true}
        width={800}
        closeIcon={<span className='icon iconfont modal-close-icon'>&#xe6ef;</span>}>
        <div className='customer-info'>
          <span className='customer-name'>
            <span>学员：</span>
            <span>{storeCustomerName}</span>
          </span>
          <span className='customer-phone'>
            <span>手机号：</span>
            <span>{storeCustomerPhone}</span>
          </span>
        </div>
        <div className='table-box'>
          <Table className='plan-table' dataSource={[planDataSource]} columns={this.parsePlanDataColumns()} pagination={false} />
          <Table
            className='task-table'
            rowKey={(record) => record.taskId}
            dataSource={taskDataSource}
            columns={this.parseTaskColumns()}
            pagination={false}
            expandable={{
              expandedRowRender: (record, index) => {
                return (
                  <div>
                    <Table
                      showHeader={false}
                      className='child-table'
                      rowKey={(record) => record.courseId}
                      dataSource={record.courseVOList}
                      columns={this.parseCourseColumns(index)}
                      pagination={false}
                      expandable={{
                        expandedRowRender: (chapterRecord, chapterIndex) => {
                          return (
                            <div>
                              <Table
                                showHeader={false}
                                dataSource={chapterRecord.courseChapterList}
                                columns={this.parseChapterColumns(chapterIndex)}
                                pagination={false}
                              />
                            </div>
                          );
                        },
                        rowExpandable: (record) => record.courseChapterList && record.courseChapterList.length > 1,
                      }}
                    />
                  </div>
                );
              },
              rowExpandable: (record) => record.courseVOList && record.courseVOList.length !== 0,
            }}
            rowClassName={(record, index) => {
              if (index % 2 === 0) {
                return 'odd-row';
              } else {
                return 'even-row';
              }
            }}
          />
        </div>
      </Modal>
    );
  }
}

export default UserLearnDetailModal;
