/*
 * @Author: 吴文洁
 * @Date: 2020-04-29 10:26:32
 * @LastEditors: yuananting
 * @LastEditTime: 2021-04-07 10:13:06
 * @Description: 内容线路由配置
 */
import Home from '@/modules/home/Home';
import EmployeesManagePage from '@/modules/store-manage/EmployeesManagePage';
import personalInfoPage from '@/modules/personalInfo';
import UserManagePage from '@/modules/store-manage/UserManagePage';
import StoreDecorationPage from '@/modules/store-manage/StoreDecorationPage';
import CourseCatalogPage from '@/modules/store-manage/CourseCatalogPage';
import LiveCoursePage from '@/modules/course-manage/LiveCoursePage';
import AddLivePage from '@/modules/course-manage/AddLive'
import VideoCoursePage from '@/modules/course-manage/video-course'
import GraphicsCoursePage from '@/modules/course-manage/graphics-course'
import AddVideoCoursePage from '@/modules/course-manage/video-course/AddVideoCourse'
import AddGraphicsCoursePage from '@/modules/course-manage/graphics-course/AddGraphicsCourse'
// import DataList from '@/modules/course-manage/DataList/DataList';
// import ClassBook from '@/modules/resource-disk';
import ResourceDisk from '@/modules/resource-disk';
import SwitchRoute from '@/modules/root/SwitchRoute';
import PlanPage from '@/modules/plan-manage/PlanPage';
import AddPlanPage from '@/modules/plan-manage/AddPlan';
import LearningDataPage from '@/modules/plan-manage/LearningData';
import StoreInfoPage from '@/modules/store-manage/StoreInfo';
import CourseCategoryManage from '@/modules/teach-tool/components/CourseCategoryManage';
import QuestionManageIndex from '@/modules/teach-tool/question-manage/Index';
import OperateQuestion from "@/modules/teach-tool/question-manage/OperateQuestion";
import PaperManageIndex from '@/modules/teach-tool/paper-manage/Index';
import OperatePaper from "@/modules/teach-tool/paper-manage/OperatePaper";
import ExaminationManagerIndex from '@/modules/teach-tool/examination-manager/Index';

const mainRoutes = [
  {
    path: '/home',
    component: Home,
    name: '中心首页'
  },
  {
    path: '/employees-manage',
		component: EmployeesManagePage,
		name: '员工管理'
  },
  {
    path: '/personal-info',
		component: personalInfoPage,
		name: '个人信息'
  },
  {
    path: '/user-manage',
		component: UserManagePage,
		name: '用户管理'
  },
  {
    path: '/store-decoration',
		component: StoreDecorationPage,
		name: '店铺装修'
  },
  {
    path: '/course-catalog',
		component:CourseCatalogPage,
		name: '课程分类'
  },
  {
    path: '/live-course',
		component:LiveCoursePage,
		name: '直播课'
  },
  {
    path: '/video-course',
		component:VideoCoursePage,
		name: '视频课'
  },
  {
    path: '/graphics-course',
		component: GraphicsCoursePage,
		name: '图文课'
  },
  {
    path: '/create-live-course',
		component:AddLivePage,
		name: '创建直播课'
  },
  {
    path: '/create-video-course',
		component:AddVideoCoursePage,
		name: '创建视频课'
  },
  {
    path: '/create-graphics-course',
		component:AddGraphicsCoursePage,
		name: '创建图文课'
  },
  {
    path: '/resource-disk',
		component:ResourceDisk,
		name: '资料云盘'
  },
  {
    path: '/question-manage-index',
		component:QuestionManageIndex,
		name: '题库'
  },
  {
    path: '/paper-manage-index',
		component:PaperManageIndex,
		name: '试卷'
  },
  {
    path: '/examination-manage-index',
		component:ExaminationManagerIndex,
		name: '考试'
  },
  {
    path: '/course-category-manage',
		component:CourseCategoryManage,
		name: '分类管理'
  },
  {
    path: '/switch-route',
		component: SwitchRoute,
		name: '登录后跳转承载页'
  },
  {
    path:'/plan',
    component: PlanPage,
		name: '培训计划'
  },
  {
    path: '/create-plan',
		component:AddPlanPage,
		name: '创建视频课'
  },
  {
    path: '/store-info',
		component:StoreInfoPage,
		name: '店铺信息'
  },
  {
    path: '/learning-data',
    component:LearningDataPage,
    name: '学习数据'
  }

]

export default mainRoutes;