import React, { useEffect, useState } from 'react'
import { TreeSelect } from 'antd'
function CourseCatalogSelect(props) {
  let {
    courseCatalogList = [],
    showSearch = false,
    value = '',
    treeNodeFilterProp = 'title',
    style = { width: 240 },
    dropdownStyle = { maxHeight: 300, overflow: 'auto' },
    placeholder = '请选择课程类型',
    allowClear = true,
    onChange = () => {},
  } = props
  let [treeData, setTreeData] = useState([])
  let [defaultValue, setDefaultValue] = useState(null)
  console.log('aaaaaaa', courseCatalogList, value)
  useEffect(() => {
    console.log('useEffect', courseCatalogList, value)
    function renderTreeNodes(list) {
      let newTreeData = list.map((item) => {
        item.title = item.categoryName
        item.value = item.id
        item.key = item.id
        console.log(value, item.value, value === item.value, 'item.categoryName')
        if (value === item.value) {
          setDefaultValue(item.title)
        }
        if (item.sonCategoryList) {
          item.children = renderTreeNodes(item.sonCategoryList)
        }
        return item
      })
      return newTreeData
    }
    let categoryList = renderTreeNodes(courseCatalogList)
    setTreeData(categoryList)
  }, [props.value])

  return (
    <TreeSelect
      defaultValue={[defaultValue]}
      treeNodeLabelProp='categoryName'
      showSearch={showSearch}
      treeNodeFilterProp={treeNodeFilterProp}
      style={style}
      dropdownStyle={dropdownStyle}
      treeData={treeData}
      placeholder={placeholder}
      allowClear={allowClear}
      // value={value}
      treeDefaultExpandAll
      onChange={(value, label) => {
        onChange(value, label)
      }}
    />
  )
}
export default CourseCatalogSelect
