import React from 'react';
import { Modal, Table } from "antd";
import ChargeArgeement from "./ChargeArgeement";
import "./AccountChargeModal.less";
class AccountChargeRecords extends React.Component{
  constructor(props) {
    super(props);
    this.state = {
      list: [],
    };
  }
  componentDidMount() {
    this.getList();
  }

  getList = () => {
    const { instId } = window.currentUserInstInfo;
    axios
      .Business("public/liveAssets/rechargeProtocol", { instId })
      .then((res) => {
        const list = res.result;
        this.setState({
          list,
        });
      });
  };
  handleProtcol = (id) => {
    const agreement = (
      <ChargeArgeement
        id={id}
        close={() => {
          this.setState({
            agreement: null,
          });
        }}
      />
    );
    this.setState({
      agreement,
    });
  };
  render() {
    const columns = [
      {
        title: "签订人",
        dataIndex: "operatorName",
        width: 140
      },
      { title: "关联订单ID", dataIndex: "orderId" },
      {
        title: "签订时间",
        dataIndex: "createTime",
        render: (text, record) => {
          return <span>{formatDate("YYYY-MM-DD H:i", parseInt(text))}</span>;
        },
      },
      {
        title: "签订协议",
        dataIndex: "operate",
        render: (text, record) => {
          return (
            <div
              style={{ cursor: "pointer", color: "#FC9C6B" }}
              onClick={() => {
                this.handleProtcol(record.protocolId);
              }}
            >
              《服务协议》
            </div>
          );
        },
      },
    ];
    const { list } = this.state;
    return (
      <Modal
        title="服务协议签订记录"
        visible={true}
        width={680}
        footer={null}
        maskClosable={false}
        onCancel={() => {
          this.props.close();
        }}
      >
        <div>
          <div
            style={{
              fontSize: "14px",
              color: "#666666",
              lineHeight: "20px",
              marginBottom: 16,
            }}
          >
            以下是本校区自助充值时签订协议的记录
          </div>
          <Table
            size="middle"
            columns={columns}
            dataSource={list}
            pagination={false}
            bordered
          />
        </div>
        {this.state.agreement}
      </Modal>
    );
  }
}

export default AccountChargeRecords;
