import React from 'react';
import { withRouter } from "react-router-dom";
import { Tabs } from 'antd';
import Breadcrumbs from "@/components/Breadcrumbs";
import EmployeeShareData from './components/EmployeeShareData';
import UserLearningData from './components/UserLearningData';
import PlanService from '@/domains/plan-domain/planService';
import Bus from '@/core/bus';
import './LearningData.less';

const defaultCover = 'https://image.xiaomaiketang.com/xm/YNfi45JwFA.png';
class LearningData extends React.Component {
  constructor(props) {
    super(props);
    const id = getParameterByName("id");
    this.state = {
      id,
      planName:"",
      coverUrl:defaultCover,
      courseNum:0,
      created:"",
      cultureCustomerNum:0,
      activeKey:"employeeShareData"
    }
  }
  componentDidMount(){
    this.getPlanDetail();
    Bus.bind('watchDataView',() =>{this.setState({activeKey:"userLearningData"}) })
  }
  
  getPlanDetail = ()=>{
    const { id } = this.state;
    PlanService.getTrainingPlanDetail({
        planId: id
    }).then((res) => {
        const {
            planName,
            courseMediaVOS,
            courseNum,
            created,
            cultureCustomerNum
        } = res.result;
        let coverUrl;
        courseMediaVOS.map((item) => {
          if(item.contentType === "COVER"){
            coverUrl = item.mediaUrl;
          }
          return item;
        })
        this.setState({
          planName,
          coverUrl: coverUrl || defaultCover,
          courseNum,
          created,
          cultureCustomerNum:0
        })
    })
  }
  render() {
    const {planName,coverUrl,courseNum,created,cultureCustomerNum,activeKey} = this.state;
    return (
      <div className="page plan-learn-data-list">
        <Breadcrumbs
          navList="学习数据"
          goBack={() => {
            RCHistory.goBack();
          }}
        />
        <div className="plan-info">
          <div className="plan-intro">
            <div className="plan-img-con">
              <img src="https://image.xiaomaiketang.com/xm/YNfi45JwFA.png"/>
            </div>
            <div>
              <div className="plan-name">
                {planName}
              </div>
              <div className="create-course">
                <span className="createUser">创建人：张老师</span>
                <span className="split">|</span>
                <span className="course-total">课程总数量：{courseNum}</span>
              </div>
              <div className="create-time">创建时间：{formatDate('YYYY-MM-DD H:i', created)} </div>
            </div>
          </div>
          <div className="join">
            <div className="number">{cultureCustomerNum}</div>
            <div className="text">参培人数</div>
          </div>
        </div>
        <div className="box">
          <Tabs activeKey={activeKey} onChange={(activeKey)=>{this.setState({activeKey})}}>
            <Tabs.TabPane tab="员工分享数据" key="employeeShareData">
                <EmployeeShareData/>
            </Tabs.TabPane>
            <Tabs.TabPane tab="用户学习数据" key="userLearningData">
                <UserLearningData/>
            </Tabs.TabPane>
          </Tabs>
        </div>

      </div>
    )
  }
}

export default withRouter(LearningData);