import React from 'react';
import {Table, Modal,Input} from 'antd';
import { PageControl } from "@/components";
import PlanService from '@/domains/plan-domain/planService'
import User from '@/common/js/user'
import './UnbundEmployeeModal.less';
import _ from "underscore";
const { Search } = Input;
class UnbundEmployeeModal extends React.Component {
  constructor(props) {
    super(props);
    this.state = {
      dataSource:[],
      selectOperatorList:[]
    };
  }
  componentDidMount() {
    this.handleFetchDataList();
  }
 
   // 获取绑定员工列表
  handleFetchDataList = () => {
    const params ={
        planId: getParameterByName("id"),
        storeCustomerId: this.props.storeCustomerId,
        storeId:this.props.storeId
    }
    PlanService.getPlanCustomerAboutUser(params).then((res) => {
      const { result = {} } = res ;
      this.setState({
        dataSource: result,
      });
    });
  }

  // 请求表头
  parseColumns = () => {
    const columns = [
      {
        title: '员工',
        key: 'storeUserName',
        dataIndex: 'storeUserName'
      },
      {
        title: '角色',
        key: '',
        dataIndex: ''
      },
      {
        title: '手机号',
        key: 'storeUserPhone',
        dataIndex: 'storeUserPhone'
      }
    ];
    return columns;
  }
  selectOperator = (record,selected) =>{
    // console.log('selected',selected);
    this.setState({selectOperatorList:record});
  }
  confirmUnbund = ()=>{
    
    const { selectOperatorList } = this.state;

    console.log('selectOperatorList',selectOperatorList);

    const params = {
      planId:getParameterByName("id"),
      removeUserId:_.pluck(selectOperatorList, 'storeUserId'),
      storeCustomerId:this.props.storeCustomerId,
      storeId:User.getStoreId(),
      storeUserId:User.getStoreUserId()
    }
    PlanService.removePlanCustomer(params).then((res) => {
      message.success('解绑成功');
      this.props.onClose();
    });
  }
  render() {
    const { size,dataSource,totalCount,query,selectOperatorList} = this.state;
    const { visible } = this.props;
    return (
        <Modal
          title="选择需解绑的员工"
          onCancel={this.props.onClose}
          maskClosable={false}
          visible={visible}
          className="select-operator-modal"
          closable={true}
          width={800}
          onOk={() => {this.confirmUnbund()}} 
          closeIcon={<span className="icon iconfont modal-close-icon">&#xe6ef;</span>} 
        >
          <div>
            <Table
              rowKey={record => record.storeUserId}
              dataSource={dataSource}
              columns={this.parseColumns()}
              pagination={false}
              bordered
              rowSelection={{
                type: 'checkbox',
                onSelect: (record, selected) => {
                  this.selectOperator(record, selected)
                },
                onSelectAll: (selected, _selectedRows, changeRows) => {
                  this.setState({selectOperatorList:selected});
                }
              }}
            />
          </div>
        </Modal>
    )
  }
}

export default UnbundEmployeeModal;