/*
 * @Author: zhangleyuan
 * @Date: 2020-11-27 15:06:31
 * @LastEditors: zhangleyuan
 * @LastEditTime: 2020-11-30 17:00:39
 * @Description: 描述一下
 * @@Copyrigh: © 2020 杭州杰竞科技有限公司 版权所有
 */


import React, { useEffect, useState } from "react";
import { withRouter } from "react-router-dom";
import {Form,Button,Input} from "antd";
import Breadcrumbs from "@/components/Breadcrumbs";
import UpLoad from "../common/UpLoad";
import _ from 'underscore';
import $ from 'jquery';
import baseImg from '@/common/images/xiaomai-IMG.png';
import {CropperModal} from '@/components/';
import IdentificationModal from './IdentificationModal';
import ChangePhoneModal from './ChangePhoneModal';

import './index.less';
const FormItem = Form.Item;
function PersonalInfoPage() {
  const [avatar,setAvatar]  = useState(baseImg);
  const [imgUrl, setImgUrl] = useState(avatar);
  const [cropperModalVisible, setCropperModalVisible] = useState(false);
  const [IdentificationModalVisible, setIdentificationModalVisible] = useState(false);
  const [changePhoneModalVisible, setChangePhoneModalVisible] = useState(false);

  //Todo
  const [phone,setPhone] = useState("18226927277");

  function _handleUpdateAvatar(e: any): any {
    const avatar = e.target.files[0];
    const newUrl = URL.createObjectURL(avatar);
    const $image = $('#image');
    setImgUrl(newUrl);
    setCropperModalVisible(true);
  }

  function _onUpload(): any {
    $('#CrpperAvatarPic').trigger('click');
  }

  function changeAvatar(img:string):any{
    setAvatar(img);
    setImgUrl(img);
  }

  function closeCropperModal():any{
    setCropperModalVisible(false);
  }
  function identificationConfirm():any{
    setIdentificationModalVisible(false);
    console.log('111');
    setChangePhoneModalVisible(true);
  }
  function changePhoneModalConfirm():any{
    
  }
  return (
    <div className="page personal-info-page">
      <div className="page-content">
        <div className="content-header"> 
          <Breadcrumbs
            navList="个人设置"
            goBack={() => { 
              window.RCHistory.goBack();
            }}
          />
          </div>
        <div className="box">
        <Form>
          <div className="avatat-item">
            <span className="label">头像：</span>
            <Button id="click_upload_btn" onClick={_onUpload}>点击上传</Button>
            <input
              type="file"
              accept="image/*"
              id="CrpperAvatarPic"
              style={{ display: 'none' }}
              onChange={_handleUpdateAvatar} />
            <img className="avatar" src={avatar}></img>
            { cropperModalVisible &&
              <CropperModal 
                imgUrl={imgUrl}
                save={changeAvatar}
                close={closeCropperModal}
              />
            }
          </div>
          <div className="name-item">
            <span className="label">姓名：</span>
            <Input placeholder="请输入姓名" style={{ width:300,height:32}} />
          </div>
          <div className="phone-item">
            <span className="label">手机号：</span>
            <span>{phone}</span>
            <Button className="changePhoneBtn" onClick={()=>{setIdentificationModalVisible(true)}}>更换手机号</Button>
          </div>
          <div>
            <Button type="primary">保存</Button>
          </div>
        </Form>
        </div>
        {
          IdentificationModalVisible  && <IdentificationModal  phone={phone} onClose={()=>{setIdentificationModalVisible(false)}} onConfirm={()=>{identificationConfirm()}}/>
        }
        
        {
          changePhoneModalVisible  && <ChangePhoneModal   onClose={()=>{setChangePhoneModalVisible(false)}} onConfirm={()=>{changePhoneModalConfirm()}}/>
        }
      </div>
      
    </div>
  );
}

export default withRouter(PersonalInfoPage);
