/*
 * @Author: 吴文洁
 * @Date: 2019-07-10 10:30:49
 * @LastEditors: wufan
 * @LastEditTime: 2020-12-01 17:30:13
 * @Description:
 */
import React from 'react'
import { withRouter} from 'react-router-dom';
import {ConfigProvider } from 'antd';
import Header from './Header'
import Menu from './Menu'
import Main from './Main'
import { Route, Switch } from 'react-router-dom'
import zhCN from 'antd/es/locale/zh_CN'
import User from '@/common/js/user';
import axios from 'axios';
import BaseService from "@/domains/basic-domain/baseService";

class App extends React.Component {
  constructor(props) {
    super(props)
    this.state = {
     
    }
  }
  componentDidMount() {
    this.getUserStore()
  }

  getUserStore = () => {
    const userId = User.getUserId();

    BaseService.getUserStore({ userId }).then((res) => {
      console.log(res.result);
      const { storeGroupVOS, storeVOS } = res.result;
    });
  }

  render() {
    return [
      <div id="home">
        <Header/>
        <ConfigProvider locale={zhCN}>
          <Main/>
        </ConfigProvider>
        <Menu/>
      </div>
    ]
  }
}
export default withRouter(App)
