/*
 * @Author: wufan
 * @Date: 2021-05-11 10:21:37
 * @LastEditors: wufan
 * @LastEditTime: 2021-05-11 18:05:01
 * @Description: 企业微信api
 * @@Copyrigh: © 2020 杭州杰竞科技有限公司 版权所有
 */

import User from "@/common/js/user";
import Service from "@/common/js/service";

export default class WechatApi {
  static async initConfig(params = { isAgentConfig: false, url: "" }) {
    return Service.Hades("anon/hades/getWxWorkJSAPISignature", {
      storeId: User.getStoreId(),
      url: params.url,
    }).then((result) => {
      const res = result.result;
      wx.config({
        beta: true, // 必须这么写，否则wx.invoke调用形式的jsapi会有问题
        debug: false, // 开启调试模式,调用的所有api的返回值会在客户端alert出来，若要查看传入的参数，可以在pc端打开，参数信息会通过log打出，仅在pc端时才会打印。
        appId: res.corpId, // 必填，企业微信的corpID
        timestamp: res.timeStamp, // 必填，生成签名的时间戳
        nonceStr: res.nonceStr, // 必填，生成签名的随机串
        signature: res.signature, // 必填，签名，见 附录-JS-SDK使用权限签名算法
        jsApiList: [
          "chooseImage",
          "shareToExternalContact",
          "selectExternalContact",
          "selectEnterpriseContact",
        ],
      });

      if (params.isAgentConfig) {
        return new Promise((resolve, reject) => {
          wx.ready(() => {
            Service.Hades("anon/hades/getWxWorkJSAPISignature", {
              storeId: User.getStoreId(),
              url: params.url,
            }).then((result2) => {
              const res2 = result2.result;
              wx.agentConfig({
                corpid: res2.corpId, // 必填，企业微信的corpid，必须与当前登录的企业一致
                agentid: res2.agentId, // 必填，企业微信的应用id （e.g. 1000247）
                timestamp: res2.timeStamp, // 必填，生成签名的时间戳
                nonceStr: res2.nonceStr, // 必填，生成签名的随机串
                signature: res2.signature, // 必填，签名，见附录-JS-SDK使用权限签名算法
                jsApiList: [
                  "selectExternalContact",
                  "getCurExternalContact",
                  "getContext",
                  "shareToExternalContact",
                  "sendChatMessage",
                  "shareToExternalChat",
                ],
                success: (res) => {
                  console.log(res, "res-agentconfig");
                  console.info("window.WWOpenData", window.WWOpenData);
                  resolve(res);
                },
                fail: (err) => {
                  console.log(err, "err-agentconfig");
                  reject(err);
                },
              });
            });
          });
        });
      }
    });
  }

  static getCurExternalContact() {
    return new Promise((resolve, reject) => {
      wx.ready(() => {
        wx.invoke("getCurExternalContact", {}, function (res) {
          if (res.err_msg == "getCurExternalContact:ok") {
            resolve(res.userId); //返回当前外部联系人userId
          } else {
            reject(res.err_msg); //错误处理
          }
        });
      });
    });
  }

  static getContext() {
    return new Promise((resolve, reject) => {
      wx.ready(() => {
        wx.invoke("getContext", {}, function (res) {
          if (res.err_msg == "getContext:ok") {
            resolve(res.entry); //返回进入H5页面的入口类型，目前有normal、contact_profile、single_chat_tools、group_chat_tools、chat_attachment
          } else {
            reject(res.err_msg); //错误处理
          }
        });
      });
    });
  }
}
