import React from 'react';
import LiveCourseFilter from './components/LiveCourseFilter';
import LiveCourseOpt from './components/LiveCourseOpt';
import LiveCourseList from './components/LiveCourseList';

class LiveCoursePage extends React.Component {

  constructor(props) {
    super(props);
    // const { instId, teacherId } = window.currentUserInstInfo;
    this.state = {
      courseList: [],    // 直播课列表
      query: {
        current: 1,
        size: 10,
        instId:0,
        teacherId:0
      },
      total: 0,
      loading: true,
    }
  }
  componentWillMount() {
    this.handleFetchLiveList(this.state.query);
  }
  // // 获取直播课列表
  // handleFetchLiveList = (_query) => {
  //   const { query } = this.state;
  //   const { teacherId } = window.currentUserInstInfo;

  //   const params = {
  //     teacherId: teacherId ? teacherId : null,
  //     ...query,
  //     ..._query,
  //   };
  //   this.setState({ query: params });

  //   window.axios
  //     .Apollo("public/businessLive/getLargeClassLiveList", params)
  //     .then((res) => {
  //       const { result: { records = [], total } } = res;
  //       this.setState({
  //         total,
  //         courseList: records
  //       });
  //     }) .finally(() => {
  //       this.setState({ loading: false });
  //     });
  // }
  handleFetchLiveList= (_query) => {
    const _courseList=[
      {
        applyMode: "ANYONE",
        autoSendReport: "AUTO",
        channel: "XIAOMAI",
        consumeClassTime: 30,
        consumeHourNum: 1,
        courseDocumentCount: 0,
        courseMediaVOS: [],
        courseName: "0988",
        courseState: "EXPIRED",
        createdReport: "INVALID",
        endTime: 1607515751000,
        haveRecord: "NO",
        instId: "1213001850820476929",
        intro: "",
        liveCourseId: "1336612757182279681",
        liveType: "LARGE_CLASS_LIVE",
        needRecord: "YES",
        nickname: "张莹",
        podium: 0,
        quota: 1,
        roomId: 9984,
        startTime: 1607508551000,
        teacherId: "1226497609046880257",
        thirdPartType: "TENCENT",
        whetherRecord: "YES",
      }
    ];
    this.setState({
      courseList: _courseList,
      total:1
    });
  }
  render() {
    const { query, total, courseList } = this.state;

    return (
      <div className="page big-live-page">
        <div className="content-header">大班直播</div>
        <div className="box">
          <LiveCourseFilter
            onChange={this.handleFetchLiveList}
          />
          <LiveCourseOpt />
          <LiveCourseList
            query={query}
            total={total}
            courseList={courseList}
            onChange={this.handleFetchLiveList}
          /> 
        </div>
      </div>
    )
  }
}

export default LiveCoursePage;