/*
 * @Author: 吴文洁 
 * @Date: 2020-07-15 17:44:24 
 * @Last Modified by: mikey.zhaopeng
 * @Last Modified time: 2020-11-23 22:06:33
 * @Description: 添加直播课-上课信息
 */

import React from 'react';
import {TimePicker, Select, Spin, Tooltip } from 'antd';
import {InfoCircleFilled} from '@ant-design/icons';
import StoreService from "@/domains/store-domain/storeService";

// import TeacherSelectV5 from "@/modules/classManage_V5/classDetail/TeacherSelectV5";

import ChargeExplainModal from '../modal/ChargeExplainModal';
import SelectStudent from '../modal/select-student/index';
import MultipleDatePicker from '@/components/MultipleDatePicker';
import moment from 'moment';
import './AddLiveClass.less';

const defaultTeacherQuery = {
  size: 10,
  current: 1,
  nickName:null
}
class AddLiveClass extends React.Component {
  constructor(props) {
    super(props);
    this.state = {
      loading: false,
      hasNext: false,
      teacherQuery: defaultTeacherQuery,
      teacherList:[],
      assistantList: [],     // 助教老师列表
      addLiveType: props.addLiveType
    }
  }

  componentDidMount() {
    this.getTeacherList();
    this.getAssistantList();
  }
  getTeacherList(current = 1, selectList){
    const { teacherQuery,teacherList} = this.state;
    const _query = {
      ...teacherQuery,
      current,
      size:10
    };
    StoreService.getEmployeeList( _query).then((res) => {
        const { result = {} } = res;
        const { records = [], total = 0, hasNext } = result;
        const list = current > 1 ? teacherList.concat(records) : records;
        this.setState({
          hasNext,
          teacherList: list,
        })
    });
  }
  // 获取助教老师列表
  getAssistantList = (current = 1, selectList) => {
    // const { query, assistantList } = this.state;
    // const { selectedAssistant } = this.props;
    // const { teacherId, assistant } = this.props.data;
    // const idList = selectList ? selectList : assistant;
    // const _query = {
    //   ...query,
    //   current,
    //   idList,
    //   size: idList.length <= 10 ? 10 : idList.length + 10
    // };
    // this.setState({ query: _query });
    // axios.Apollo("public/businessLive/queryAdminByName", _query).then((res) => {
    //   const { result = {} } = res;
    //   const { records = [], total = 0, hasNext } = result;
    //   const list = current > 1 ? assistantList.concat(records) : records;
    //     const _assistantList = _.uniq(
    //       selectedAssistant.concat(
    //         _.reject(list, (item) => item.id === teacherId)
    //       ),
    //       false,
    //       (item) => item.id
    //     );
    //     this.setState({
    //       hasNext,
    //       assistantList: list,
    //       _assistantList: _assistantList
    //     })
    // });
  }

  // 修改直播模式
  handleChangeLiveType = (e) => {
    this.setState({
      addLiveType: e.target.value,
    });
    this.props.onChange('liveType', e.target.value);
  };


  
  // 滑动加载更多
  handleScroll = (e) => {
    console.log('srcoll')
    const { hasNext } = this.state;
    const container = e.target;
    const scrollToBottom = container &&  container.scrollHeight <= container.clientHeight + container.scrollTop;
    if (scrollToBottom && hasNext) {
      const { query } = this.state;
      this.getAssistantList(query.current + 1);
    }
  }

  disabledDate = (current) => {
    return current.valueOf() < moment().subtract(1, "days")
  };

  selectMultiDate = (calendarTime) => {
    this.setState({
      calendarTime
    })
  }
  render() {
    const {
      loading,
      teacherList,
      teacherQuery
    } = this.state;

    // pageType: 页面类型：add->新建、edit->编辑
    // liveScene: 直播场景: interactive -> 互动班课 large -> 大班直播
    // data：表单数据
    // selectedAssistant: 已经选择的助教

    const { pageType, liveScene, data, selectedAssistant, isXiaomai,isEdit, after} = this.props;
    const {
      endTime,
      startTime,
      studentList,
      consumeStudentList,
      calendarTime,
     
    } = data;
    // 已选择的上课学员数量(不扣课时)
    const hasSelectedStu = studentList.length;

    // 已选择的上课学员数量(扣课时)
    const hasSelectedDeductionStu = consumeStudentList.length;

    return (
      <Spin spinning={loading}>
        <div className="add-live__class-info">
          <div className="course">
            <div className="day">
              <span className="label">
                <span className="require">*</span>
                  上课日期
                  <Tooltip 
                    overlayStyle={{maxWidth: 300, zIndex: '9999'}} 
                    title={<div style={{width: '266px'}}>支持按上课日期批量创建直播课，创建后按“课程名称_日期”命名，例如：<br/>张三的语文课_9月18日<br/>张三的语文课_9月19日......</div>}>
                    <InfoCircleFilled className="tip-icon"/>
                  </Tooltip>：
                </span>
              <div>
                <div className='select-day'>
                  已选 
                  <span className="mark-day">
                    {isLongArr(calendarTime)
                      ? calendarTime.length : 0
                    }
                  </span> 天
                </div>
                <MultipleDatePicker
                  selectDateList={calendarTime}
                  onSelect={this.selectMultiDate}
                  canSelectTodayBefore={false}
                />
              </div>
              
            </div>
            
            <div className="hour" id="hour">
              <span className="label"><span className="require">*</span>上课时间：</span>
              <TimePicker
                format="HH:mm"
                value={startTime ? moment(startTime) : null}
                placeholder="开始时间"
                style={{ width: 100, minWidth: 100}}
                onChange={(time) => {
                  this.props.onChange('startTime', time);
                }}
              />&nbsp;&nbsp;~&nbsp;&nbsp; 
              <TimePicker
                format="HH:mm"
                value={endTime ? moment(endTime) : null}
                placeholder="结束时间"
                style={{ width: 100, minWidth: 100 }}
                onChange={(time) => { 
                  this.props.onChange('endTime', time)
                }} 
              />
            </div>
          </div>
          <div className="teacher">
            <span className="label"><span className="require">* </span>讲师：</span>
            <Select
              placeholder="请选择讲师"
              style={{ width: 240, marginTop: 6 }}
              filterOption={(input, option) => option}
              // onPopupScroll={this.handleScroll}
              onChange={(value) => {
                this.props.onChange('teacherId', value) 
              }}
              onSearch={(value) => {
                teacherQuery.nickName = value
                this.setState({
                  teacherQuery
                }, () => {
                  this.getAssistantList()
                })
              }}
            >
              {_.map(teacherList, (item, index) => {
                return (
                  <Select.Option value={item.id} key={item.id}>{item.nickName}</Select.Option>
                );
              })}
            </Select>
          </div>
          <div className="assistant-teacher">
            <span className="label">助教：</span>
            <Select
              id="assistant"
              mode="multiple"
              placeholder="请选择助教老师"
              style={{ width: 240, marginTop: 6 }}
              filterOption={(input, option) => option}
            >
              
            </Select>
          </div>
        </div>
      </Spin>
    )
  }
}

export default AddLiveClass;