/*
 * @Author: 吴文洁 
 * @Date: 2019-11-08 10:31:08 
 * @Last Modified by: 吴文洁
 * @Last Modified time: 2020-02-25 15:50:21
 礼品集市常量
 */
import Enum from '@/core/enum';

const OrderStateEnum = new Enum([{
  key: 'PAY_WAITING',
  value: '待付款',
  icon: 'https://xiaomai-image.oss-cn-hangzhou.aliyuncs.com/1573191434106.png?x-oss-process=image/resize,w_80,limit_0'
}, {
  key: 'PAY_TIMEOUT',
  value: '支付超时',
  icon: 'https://xiaomai-image.oss-cn-hangzhou.aliyuncs.com/1573191455406.png?x-oss-process=image/resize,w_80,limit_0'
}, {
  key: 'WATING_AUDIT',
  value: '待受理',
  desc: '订单正在受理中，请耐心等待',
  icon: 'https://xiaomai-image.oss-cn-hangzhou.aliyuncs.com/1573191403102.png?x-oss-process=image/resize,w_80,limit_0'
}, {
  key: 'PAY_SUCCESS',
  value: '待受理',
  desc: '订单正在受理中，请耐心等待',
  icon: 'https://xiaomai-image.oss-cn-hangzhou.aliyuncs.com/1573191403102.png?x-oss-process=image/resize,w_80,limit_0'
}, {
  key: 'AUDIT_FAILED',
  value: '受理失败',
  icon: 'https://xiaomai-image.oss-cn-hangzhou.aliyuncs.com/1574673840912.png?x-oss-process=image/resize,w_80,limit_0'
}, {
  key: 'USER_CANCEL',
  value: '已取消',
  icon: 'https://xiaomai-image.oss-cn-hangzhou.aliyuncs.com/1573191455406.png?x-oss-process=image/resize,w_80,limit_0'
}, {
  key: 'WATING_DELIVER',
  value: '待发货',
  desc: '商品待发出，请耐心等待',
  icon: 'https://xiaomai-image.oss-cn-hangzhou.aliyuncs.com/1573191392327.png?x-oss-process=image/resize,w_80,limit_0'
}, {
  key: 'FINISH_DELIVER',
  value: '已发货',
  desc: '商品已发出，正在快马加鞭的赶来~ ',
  icon: 'https://xiaomai-image.oss-cn-hangzhou.aliyuncs.com/1573191392327.png?x-oss-process=image/resize,w_80,limit_0'
}, {
  key: 'RECEIVED',
  value: '已完成',
  desc: '本次交易已完成！',
  icon: 'https://xiaomai-image.oss-cn-hangzhou.aliyuncs.com/1573191420713.png?x-oss-process=image/resize,w_80,limit_0'
}]);

const RefundStateEnum = new Enum([{
  key: 'WAITING_SURE',
  value: '待确认',
}, {
  key: 'REFUNDING',
  value: '退款中',
}, {
  key: 'REFUND_SUCCESS',
  value: '退款成功',
}, {
  key: 'REFUND_FAILED',
  value: '退款失败',
}]);

const OrderStateMap = {
  'PAY_WAITING': '待付款',
  'USER_CANCEL': '已取消',
  'WATING_DELIVER': '待发货',
  'FINISH_DELIVER': '已发货',
  'RECEIVED': '已完成',
  'AUDIT_FAILED': '受理失败',
}

export {
  OrderStateEnum,
  RefundStateEnum,
  OrderStateMap
}