import React, { useState, useEffect } from "react";
import "./TestLinkTaskData.less";
import LeftStageList from "./LeftStageList";
import TestDetailPage from "@/modules/teach-tool/examination-manager/TestDetailPage";
import { Route, withRouter } from "react-router-dom";
import Service from "@/common/js/service";
import LottieIcon from "@/components/LottieIcon";

function TestLinkTaskData(props) {
  const [stageExamList, setStageExamList] = useState([]);
  const [activeExam, setActiveExam] = useState({});
  const [activeStage, setActiveStage] = useState({});
  const [isShow, setIsShow] = useState(true);

  useEffect(() => {
    getTrainingTaskDetail();
  }, []);

  function getTrainingTaskDetail() {
    Service.Hades("public/hades/getTaskCustomerDetail", {
      taskId: "1412706381214687233",
      storeId: "1192022572770412395",
      storeCustomerId: "1384073988114677761",
      // todolist 数据写死调接口
      // taskId: props.match.params.taskId.replace(/\?.+/, ""),
      // storeId: User.getStoreId(),
      // storeCustomerId: User.getCustomerId(),
    }).then((res) => {
      const data = { ...res.result };
      const { stageCustomerVOList = [] } = data;
      if (!!stageCustomerVOList.length) {
        setStageExamList(stageCustomerVOList);
        setActiveStage(stageCustomerVOList[0]);
        setActiveExam(stageCustomerVOList[0].courseVOList[0]);
        const { contentId, paperId } = stageCustomerVOList[0].courseVOList[0];
        const { match } = props;
        const path = `${match.url}/test-detail/1424698828831531009?paperId=1408034318353940481&userId=1351455073595023362&fromTrainingTask=true`;
        window.RCHistory.push(path);
      }
      // const { stageExamCustomerVOList = [] } = data;
      // if (stageExamCustomerVOList.length) {
      //   setStageExamList(stageExamCustomerVOList);
      //   setActiveStage(stageExamCustomerVOList[0]);
      //   setActiveExam(stageExamCustomerVOList[0].courseVOList[0]);
      // }
    });
  }

  function changeActiveExam(_activeExam, _activeStage) {
    console.log("_activeExam", _activeExam);
    setActiveExam(_activeExam);
    setActiveStage(_activeStage);
    const { contentId, paperId } = _activeExam;

    window.RCHistory.push({
      pathname: `${
        props.match.url
      }/test-detail/${1424698828831531009}?paperId=${1408034318353940481}&userId=${1351455073595023362}&fromTrainingTask=true`,
    });
    // window.RCHistory.push({
    //   pathname: `${
    //     props.match.url
    //   }/test-detail/${contentId}?paperId=${paperId}&userId=${111}`,
    // });
  }

  function toggleShowBar(diretion) {
    if (diretion === "left") {
      setIsShow(false);
    } else {
      setIsShow(true);
    }
  }

  return (
    <div>
      {stageExamList.length ? (
        <div className={`test-link-task-data ${!isShow ? 'hidden':''}`}>
          <div className={`left-stage-list-box ${!isShow ? 'hidden':''}`}>
            {isShow ? (
              <div
                className="left-bar"
                onClick={() => {
                  toggleShowBar("left");
                }}
              ></div>
            ) : (
              <div
                className="right-bar"
                onClick={() => {
                  toggleShowBar("right");
                }}
              ></div>
            )}
            <LeftStageList
              stageExamList={stageExamList}
              activeExam={activeExam}
              changeActiveExam={changeActiveExam}
              activeStage={activeStage}
            />
          </div>
          <div className={`right-exam-data-box ${!isShow ? 'hidden':''}`}>
            <Route
              path={`${props.match.url}/test-detail/:testId`}
              component={TestDetailPage}
            />
          </div>
        </div>
      ) : (
        <LottieIcon
          title={<span className="desc">暂无考试数据</span>}
          type="college"
          size={150}
        />
      )}
    </div>
  );
}

export default withRouter(TestLinkTaskData);
