/*
 * @Author: sunbingqing
 * @Date: 2019-07-24 17:21:00
 * @Last Modified by: mikey.zhaopeng
 * @Last Modified time: 2020-11-25 14:36:16
 */

import React from 'react';
import { Pagination } from 'antd';
import './PageControl.less';

interface PageControlProps {
  current: number;
  total: number;
  pageSize: number;
  showDataNums?: boolean;
  showSizeChanger?: boolean;
  size?: 'default' | 'small';
  toPage: (value: number) => void;
  className?: string;
  onShowSizeChange?: any;
  pageSizeOptions?:any
}

const PageControl = (props: PageControlProps) => {
  const { current, total, pageSize, showDataNums, showSizeChanger, size, toPage, className,
    onShowSizeChange, pageSizeOptions } = props;
  const cls = 'xm-page-control ' + className;

  function _onChange(page: number): any {
    toPage(page - 1);
  }

  return (
    <div className={cls}>
      {(showDataNums === undefined ? true : showDataNums) &&
        <span>共{total}条数据</span>
      }
      <div style={{ display: 'inline', float: 'right' }}>
        <Pagination
          size={size}
          current={current + 1}
          total={total || 0}
          pageSizeOptions={['10', '20', '50', '100']}
          onShowSizeChange={onShowSizeChange}
          showSizeChanger={showSizeChanger}
          pageSize={pageSize || 10}
          onChange={(page: any) => _onChange(page)}
          showQuickJumper
        />
      </div>
    </div>
  );
};

export default PageControl;
