import React from 'react';
import { Tabs } from 'antd';
import VideoCourseFilter from './components/VideoCourseFilter';
import VideoCourseOpt from './components/VieoCourseOpt';
import VideoCourseList from './components/VideoCourseList';
import CourseService from '@/domains/course-domain/CourseService';
import User from '@/common/js/user';
const { TabPane } = Tabs;
class VideoCourse extends React.Component {
  constructor(props) {
    super(props);
    this.state = {
      query: {
        size: 10,
        current: 1,
        storeId: User.getStoreId(),
      },
      dataSource: [], // 视频课列表
      totalCount: 0, // 视频课数据总条数
      currentTabKey: 'internal',
    };
  }

  componentWillMount() {
    // 获取视频课列表
    this.handleFetchScheduleList();
  }

  // 获取视频课列表
  handleFetchScheduleList = (_query = {}) => {
    const { currentTabKey } = this.state;
    const query = {
      ...this.state.query,
      ..._query,

      courseDivision: currentTabKey === 'external' ? 1 : null,
    };

    CourseService.videoSchedulePage(query).then((res) => {
      const { result = {} } = res || {};
      const { records = [], total = 0 } = result;
      if (Number(total) && query.size * (query.current - 1) >= Number(total)) {
        this.handleFetchScheduleList({
          ...query,
          current: 1,
        });
        return;
      }
      this.setState({
        query,
        dataSource: records,
        totalCount: Number(total),
      });
    });
  };
  currenTabChange = (currentTabKey) => {
    const { query } = this.state;
    this.setState(
      {
        currentTabKey,
        query: {
          ...query,
          current: 1,
        },
      },
      () => {
        console.log('this.state.query===>', this.state.query);
        // this.handleFetchScheduleList()
      }
    );
  };
  changeShelfState = (index, shelfState) => {
    const { dataSource } = this.state;
    dataSource[index].shelfState = shelfState;
    this.setState({
      dataSource,
    });
  };

  render() {
    const { dataSource, totalCount, query, currentTabKey } = this.state;
    return (
      <div className='page video-course-page'>
        <div className='content-header'>视频课</div>

        <div className='box'>
          <Tabs onChange={this.currenTabChange} activeKey={currentTabKey}>
            <TabPane key='internal' tab='内部课程'></TabPane>

            <TabPane key='external' tab='外部课程'></TabPane>
          </Tabs>
          {/* 搜索模块 */}
          <VideoCourseFilter currentTabKey={currentTabKey} onChange={this.handleFetchScheduleList} />
          {/* 操作模块 */}
          <If condition={currentTabKey === 'internal'}>
            <VideoCourseOpt />
          </If>
          {/* 视频课列表模块 */}
          <VideoCourseList
            type={currentTabKey}
            query={query}
            dataSource={dataSource}
            totalCount={totalCount}
            onChange={this.handleFetchScheduleList}
            changeShelfState={this.changeShelfState}
          />
        </div>
      </div>
    );
  }
}

export default VideoCourse;
