import React from 'react';
import './ChapterList.less';

function ChapterList(props){
    const { courseChapterList } = props;

    return  <div className='chapter-list-component'>
        <If condition={courseChapterList.length > 0}>
            {
                _.map(courseChapterList,(item,index) => {
                    return <div className='course-ware'>
                        <div className='course-ware__index'>{`0${index + 1 } `}</div>
                        <div className="course-ware__detail">
                            <div className='course-ware__detail__name'>{item.mediaName}</div>
                            { item.mediaType === 'VIDEO' &&
                                <div className='course-ware__detail__duration'>{window.formatDuration(item.videoDuration)}</div>
                            }
                        </div>
                    </div>
                })
            }

        </If>
    </div>
}


export default ChapterList;