import User from "@/common/js/user";
import CourseService from "@/domains/course-domain/CourseService";
import React from "react";
import { Modal } from "antd";
import { FileTypeIcon } from '@/common/constants/academic/lessonEnum'
import "./LearningDetailModal.less";

class LearningDetailModal extends React.Component {
  constructor(props) {
    super(props);
    this.state = {
      courseChapterList: [],
    };
  }

  componentDidMount() {
    this.handleFetchDataList();
  }

  // 获取观看视频数据列表
  handleFetchDataList = () => {
    const { courseId, data } = this.props;
    const params = {
      courseId,
      storeId: User.getStoreId(),
      storeCustomerId: data.storeCustomerId,
    };
    CourseService.lineDetailWatchInfo(params).then((res) => {
      const { result = [] } = res;
      this.setState({
        courseChapterList: result
      });
    });
  };

  render() {
    const { title, onClose, onOk } = this.props;
    const { courseChapterList } = this.state;
    return (
        <Modal
          footer={null}
          visible={true}
          title={title}
          width={680}
          maskClosable={false}
          closeIcon={
            <span className="icon iconfont modal-close-icon">&#xe6ef;</span>
          }
          onCancel={onClose}
          onOk={onOk}
          className="learning-detail-modal"
        >
          <div className="course-chapter__list">
            <If condition={courseChapterList.length > 0}>
              {_.map(courseChapterList, (item, index) => {
                return (
                  <div className="course-wrap">
                    <div className="course-ware" key={index}>
                      <div className="course-ware__index">{`${
                        index > 9 ? index + 1 : `0${index + 1}`
                      } `}</div>
                     <img className='course-ware__img' src={FileTypeIcon[item.mediaType]} alt='' />
                    <div className="course-ware__name">{item.courseChapterName && item.courseChapterName.replace('.MP4','')}</div>
                    </div>

                    <div className={`progress ${item.progress === 100 ? 'finish' :''}`}>{`${item.progress === 100 ? '已完成' : `${item.progress}%`}`}</div>
                  </div>
                );
              })}
            </If>
          </div>
        </Modal>
    );
  }
}

export default LearningDetailModal;
