import React from "react";
import { Tag } from 'antd'
import "./WatchDataHeader.less";

interface WatchDataHeaderProps {
  type: string;
  color?: string;
  courseName?: string;
  className?: string;
}
const WatchDataHeader = (props: WatchDataHeaderProps) => {
  const { type, color , className ,courseName} = props;

  return (
    <div className={className + " header-box"}>
      <span className="course-type" style={{color:color,border:`1px solid ${color}`}}>{type}</span>
      <span className='course-name'>{courseName}</span>
    </div>
  );
};

export default WatchDataHeader;
