import React from 'react';
import { Modal } from 'antd';
import './PreviewGraphicsModal.less';

const defaultCoverUrl = 'https://image.xiaomaiketang.com/xm/YNfi45JwFA.png';

class PreviewGraphicsModal extends React.Component {

  constructor(props) {
    super(props);
    this.state = {
      type: 'detail',
    }
  }

  render() {
    const { courseBasicInfo, courseIntroInfo } = this.props;
    const { coverUrl, courseName, categoryName } = courseBasicInfo;
    const { courseMedia, introduce } = courseIntroInfo;
    const { type } = this.state;
    return (
      <Modal
        title="预览"
        visible={true}
        width={680}
        onCancel={this.props.close}
        footer={null}
        maskClosable={false}
        closeIcon={<span className="icon iconfont modal-close-icon">&#xe6ef;</span>}
        className="preview-live-graphics-modal"
      >
        <div className="container__wrap">
          <div className="container">
            <div className="container__header">
              <img src={coverUrl || defaultCoverUrl} className="course-cover" />
            </div>
            <div className="container__body">
              <div className="title__name">{courseName}</div>
              <div className="title__categery">课程分类：{categoryName}</div>
            </div> 
            
            <div className="container__introduction">
              <div className="title">
                <span 
                  className={`title-word${type === 'detail' ? ' selected' : ''}`}
                  onClick={() => this.setState({ type: 'detail' })}
                >图文详情</span>
                <span 
                  className={`title-word${type === 'introduction' ? ' selected' : ''}`}
                  onClick={() => this.setState({ type: 'introduction' })}
                >图文简介</span>
              </div>
              <div className="container__introduction__list editor-box">
                <div
                  className="intro-item text"
                  dangerouslySetInnerHTML={{
                    __html: type === 'detail' ? courseMedia : introduce
                  }}
                />
              </div>
            </div>
          </div>
        </div>
      </Modal>
    )
  }
}

export default PreviewGraphicsModal;
