/*
 * @Author: 吴文洁
 * @Date: 2020-08-05 10:08:06
 * @LastEditors: zhangleyuan
 * @LastEditTime: 2020-12-26 15:56:49
 * @Description: 云课堂-视频课入口页面
 * @Copyright: 杭州杰竞科技有限公司 版权所有
 */

import React from 'react';

import VideoCourseFilter from './components/VideoCourseFilter';
import VideoCourseOpt from './components/VieoCourseOpt';
import VideoCourseList from './components/VideoCourseList';
import CourseService from "@/domains/course-domain/CourseService";
import User from '@/common/js/user'
class VideoCourse extends React.Component {

  constructor(props) {
    super(props);
    this.state = {
      query: {
        size: 10,
        current: 1,
        storeId:User.getStoreId()
      },
      dataSource: [],    // 视频课列表
      totalCount: 0,     // 视频课数据总条数
    }
  }

  componentWillMount() {
    // 获取视频课列表
    this.handleFetchScheduleList();
  }

  // 获取视频课列表
  handleFetchScheduleList = (_query = {}) => {
    const query = {
      ...this.state.query,
      ..._query
    };

    // 更新请求参数
    this.setState({ query });

    CourseService.videoSchedulePage(query).then((res) => {
      const { result = {} } = res || {};
      const { records = [], total = 0 } = result;
      this.setState({
        dataSource: records,
        totalCount: Number(total)
      });
    });
  }

  render() {
    const { dataSource, totalCount, query } = this.state;
    return (
      <div className="page video-course-page">
        <div className="content-header">视频课</div>

        <div className="box">
          {/* 搜索模块 */}
          <VideoCourseFilter
            onChange={this.handleFetchScheduleList}
          />

          {/* 操作模块 */}
          <VideoCourseOpt />
          
          {/* 视频课列表模块 */}
          <VideoCourseList
            query={query}
            dataSource={dataSource}
            totalCount={totalCount}
            onChange={this.handleFetchScheduleList}
          />
        </div>
      </div>
    )
  }
}

export default VideoCourse;
