/*
 * @Author: wufan
 * @Date: 2020-12-02 10:27:44
 * @LastEditors: zhangleyuan
 * @LastEditTime: 2020-12-08 19:09:48
 * @Description: Description
 * @@Copyrigh: © 2020 杭州杰竞科技有限公司 版权所有
 */
import {
    STORE_GROUP_PERMISSION,
    STORE_PERMISSION,
    STORE_GROUP_LIST,
    STORE_LIST
} from '@/store/actions/constants';
import _ from 'underscore';
import Permission from '@/common/js/permission';

const basicReducer = (state: any, action: any) => {
    
    switch (action.type) {
        case STORE_GROUP_PERMISSION:
            const storePermissionGroupList: any = _.pluck(action.payload, 'groupCode')
            return Object.assign({}, state, {
                storePermissionInfo: action.payload,
                storePermissionGroupList,
                groupPermission: new Permission(storePermissionGroupList)
            });

        case STORE_PERMISSION:
            const storeUserPermissionList: any = _.pluck(action.payload, 'groupCode')
            return Object.assign({}, state, {
                userPermissionInfo: action.payload,
                storeUserPermissionList,
                userPermission: new Permission(storeUserPermissionList)
            });

        case STORE_GROUP_LIST:
            const storeGroupList: any = action.payload;
            return Object.assign({}, state, {
                storeGroupList,
            });

        case STORE_LIST:
            const storeList: any = action.payload;
            return Object.assign({}, state, {
                storeList,
            });
        default:
            return state;
    }
}

export {
    basicReducer
}
