import React, { useEffect, useState } from 'react';
import { withRouter } from "react-router-dom";
import moment from 'moment';
import ENUM from '../../emun';
import './course.less'

function CourseTable(props: any) {
    const IndexText = ['一', '二', '三', '四', '五', '六', '七', '八', '九', '十']
    const [list, setList] = useState<any[]>([]);
    useEffect(() => {
        setList(props.info.trainingTaskList || [])
    }, [props.info.trainingTaskList])

    return <div className="courseTabContent">
        <div className="tips">{`培训目的：${'djkhdsjksdhdsj'}`}</div>

        <div className="coursecontent">
            {
                list?.map((item: any, index: number) => {
                    return <div className="task">
                        <div className="title" onClick={() => {
                            const _list = [...list];
                            _list[index].open = !_list[index].open;
                            setList(_list)
                        }}>
                            {
                                item.open ? <span className="icon iconfont open">&#xe614;</span> : <span className="icon iconfont">&#xe614;</span>
                            }
                            {
                                `${IndexText[index]}、 `
                            }
                            {item.taskName}
                        </div>
                        {
                            item.open && <div className="taskItemList">
                                {
                                    item.courseList.map((_item: any, _index: number) => {
                                        return <div className={_index == item.courseList.length - 1 ? "item noBorder" : "item"}>
                                            <div className="name">
                                                <span style={{ marginRight: 4 }}> {`${index + 1}.${_index + 1}`}</span>

                                                {
                                                    _item.courseName
                                                }
                                                {
                                                    (_item.courseType == 'LIVE') && <span className='desc'>{ENUM.courseStateShow[_item.courseState].title}</span>
                                                }
                                                {
                                                    _item.courseType == 'VOICE' && <span className='desc'>{`(共${_item.courseChapterNum}节)`}</span>
                                                }
                                            </div>

                                        </div>
                                    })
                                }

                            </div>
                        }
                    </div>

                })
            }

        </div>
        <div className="expired">
            <div className="title">失效课程</div>
            <p className="desc">为了不影响学员学习，「未成功开课」的课程已从任务中移出，具体课程如下所示：</p>
            <div className="list">
                {
                    list.map((item: any) => {
                        return <div className="item">
                            <div className="text">
                                <span className="icon iconfont" style={{ color: 'rgba(255, 79, 79, 1)' ,marginRight:4}}>&#xe80b;</span>
                                <span style={{marginRight:24}}>未成功开课</span>
                                <span className='na'>阶段一</span>
                                <span className='na'>2.1 入门培训任务</span>
                                <span >张老师 </span>
                                <span>|</span>
                                <span>{moment().format('YYYY-MM-DD HH:mm')}</span>
                            </div>
                            <div className="ope">删除记录</div>

                        </div>
                    })
                }
            </div>
        </div>

    </div>
}

export default withRouter(CourseTable)