/*
 * @Author: wufan
 * @Date: 2020-11-30 10:47:38
 * @LastEditors: Please set LastEditors
 * @LastEditTime: 2021-07-23 16:18:17
 * @Description: 学员管理页面
 * @@Copyrigh: © 2020 杭州杰竞科技有限公司 版权所有
 */

import React, { useEffect, useState } from "react";
import { withRouter } from "react-router-dom";
import _ from "underscore";
import {Tabs,Input,Tree,Button} from "antd";
import CustomGroupTabCon from './components/CustomGroupTabCon';
import DepartMentTabCon from './components/DepartMentTabCon';
import PostGroupTabCon from './components/PostGroupTabCon';
import "./NewUsersManagePage.less";

const { TabPane } = Tabs;


function UserManagePage() {
  const [currentTab, setCurrentTab] = useState("department");
  const [courseList,setCourseList] = useState([]);
  const [total, setTotal] = useState(0);
  const [query, setQuery] = useState({
    current: 0,
    size: 10,
  });
  


  return (
    <div className="page new-user-manage-page">
        <div className="content-header">学员管理</div>
        <div className="box">
          <div className="tab-box">
            <Tabs
              onChange={(key) => {
                setCurrentTab(key);
              }}
              activeKey={currentTab}
            >
              <TabPane key="department" tab="部门"></TabPane>
              <TabPane key="postGroup" tab="岗位组"></TabPane>
              <TabPane key="customGroup" tab="自定义分组"></TabPane>
            </Tabs>
          </div>
          <div className="box-body tab-con">
            {currentTab=== 'department' &&
              <DepartMentTabCon/>
            }
            {currentTab=== 'postGroup' &&
              <PostGroupTabCon/>
            }
             {currentTab=== 'customGroup' &&
              <CustomGroupTabCon/>
            }
          </div>
        </div>
    </div>
  );
}

export default withRouter(UserManagePage);
