import React, { useEffect, useState } from "react";
import { withRouter } from "react-router-dom";
import {Button,Input} from "antd";
import NewChooseMembersModal from "@/modules/college-manage/modal/NewChooseMembersModal";
import LeftStructureTree from './LeftStructureTree';
import UserTable from './UserTable'

import "./DepartMentTabCon.less";
const { Search } = Input;
function DepartMentTabCon() {
  const [chooseMembersModalVisible,setChooseMembersModalVisible] = useState(false);

  function closeChooseMembersModal(){
    setChooseMembersModalVisible(false);
  }

  return (
    <div className="department-tab-con">
        <LeftStructureTree treeType={'departMentTab'}/>
        <div className="table-con">
            <div className="operate-area">
              <Button type="primary" className="add-user-btn" onClick={()=>{setChooseMembersModalVisible(true)}}>添加学员</Button>
              <Button className="del-user-btn">删除学员</Button>
              <Button className="update-user-btn">更新列表数据</Button>
              <span className="origin-text">数据来源企业微信通讯录</span>
              <span className="view-text">查看数据更新说明</span>
            </div>
            <UserTable/>
        </div>
        {
          chooseMembersModalVisible && 
          <NewChooseMembersModal visible={chooseMembersModalVisible} type="CUSTOMER" close={()=>{closeChooseMembersModal()}} onConfirm={()=>{}}/>
        }
   
    </div>
  );
}

export default withRouter(DepartMentTabCon);