import React, { useEffect, useState } from "react";
import { withRouter } from "react-router-dom";
import { Tree, Input, Dropdown, Menu,Button} from "antd";
import AddOrEditPostGroupModal from "../modal/AddOrEditPostGroupModal";
import User from '@/common/js/user'
import StoreService from "@/domains/store-domain/storeService";
import { DepType }  from '@/domains/store-domain/constants';
import "./LeftStructureTree.less";

const { Search } = Input;
const { DirectoryTree } = Tree;
function LeftStructureTree(props) {
  const {treeType} = props;
  const [treeData,setTreeData]=useState([]);
  const [addOrEditPostGroupShow, setAddOrEditPostGroupShow] = useState(false);
  const [postGroupModalLevel, setPostGroupModalLevel] = useState(""); 
  const [operatePostGroupModalType,setOperatePostGroupModalType] = useState(""); 
  const [postGroupModalTitle,setPostGroupModalTitle] = useState("");
  const [postGroupModalLable,setPostGroupModalLable] = useState("");
  const [postGroupName, setPostGroupName] = useState("");
  const [currentGroupData,setCurrentGroupData] = useState({});
  useEffect(()=>{
    getTreeData();
  },[]);

  function getTreeData(){
    const params = {
      depType:DepType[treeType],
      enterpriseId:User.getEnterpriseId(),
      source:0,//0代表来自企培
      storeId:User.getStoreId(),
      userId:User.getUserId(),
      whetherCount:true
    }
    StoreService.getDepartmentUser(params).then((res) => {
      let { departmentVOList=[]} = res.result;
      let _treeData = handleData(departmentVOList);
      console.log("_treeData",_treeData);
      setTreeData(_treeData);
    });
  }
  function handleData(dataArray){
    const _dataArray = dataArray.map((item,index)=>{
      item.key=item.id;
      if(item.sonDepartmentVOList){
        item.children = item.sonDepartmentVOList;
        handleData(item.sonDepartmentVOList)
      }
      return item
    })
    return _dataArray;
  }
  const leftBoxWidth =
    (document.getElementById("left-box") &&
      document.getElementById("left-box").style.width) ||
    "304px";

  const moreOpenGroupOperate = (record) => (
    <Menu>
      <Menu.Item key="edit">
        <span onClick={()=>{treeType==='postGrouptab'?editPostGroup(record):editCustomGroup(record)}}>编辑</span>
      </Menu.Item>
      {record.depLevel ===0 &&
        <Menu.Item key="add" >
          <span onClick={()=>{treeType==='postGrouptab'?addPostGroup(1,record):addCustomGroup(1,record)}}>
            {props.treeType==='postGrouptab' &&
              <span>新建岗位</span>
            }
            {props.treeType==='customGroupTab' &&
              <span>新建分组</span>
            }
          </span>
        </Menu.Item>
      }
      <Menu.Item key="del">
        <span onClick={()=>{treeType==='postGrouptab'?delPostGroup(record):delCustomGroup(record)}}>删除</span>
      </Menu.Item>
    </Menu>
  );


  function closeAddOrEditPostGroupModal() {
    setAddOrEditPostGroupShow(false);
  }

  //添加岗位组/岗位
  function addPostGroup(level,record) {
    if (treeData.length === 10) {
      message.error("岗位组数量已达10个上限");
      return;
    }
    setCurrentGroupData({});
    setAddOrEditPostGroupShow(true);
    setOperatePostGroupModalType("add");
    setPostGroupModalLevel(level);
    setCurrentGroupData(record)
    if(level===0){
      setPostGroupModalTitle('添加岗位组');
      setPostGroupModalLable('岗位组');
    }else{
      setPostGroupModalTitle('添加岗位'); // sub代表岗位
      setPostGroupModalLable('岗位');
    }
  }
  //编辑岗位组/岗位
  function editPostGroup(record){
    setAddOrEditPostGroupShow(true);
    setOperatePostGroupModalType("edit");
   //level为0的时候编辑的是岗位组 大于0的时候
   setPostGroupModalLevel(record.depLevel);
   setCurrentGroupData(record)
   if(record.depLevel===0){
    setPostGroupModalTitle('编辑岗位组');
    setPostGroupModalLable('岗位组');
   }else{
    setPostGroupModalTitle('编辑岗位');
    setPostGroupModalLable('岗位');
   }
  }
  function delPostGroup(record){
    let title = '确认删除该岗位组吗？';
    let content= '删除后，该岗位组下的岗位及也将全部删除。';
   
    if(record.level>0){
      title = '确认删除该岗位吗？';
      content = '删除后，不可恢复';
    }
     Modal.confirm({
       title,
       content,
       icon: <span className='icon iconfont default-confirm-icon'>&#xe6f4;</span>,
       okText: '确定',
       okType: 'danger',
       cancelText: '取消',
       onOk: () => {
         
       },
     });
   }

  //添加自定义分组集合/分组
  function addCustomGroup(level,record) {
    if (treeData.length === 10) {
      message.error("岗位组数量已达10个上限");
      return;
    }
    setCurrentGroupData({});
    setAddOrEditPostGroupShow(true);
    setOperatePostGroupModalType("add");
    setPostGroupModalLevel(level);
    setCurrentGroupData(record)
    if(level===0){
      setPostGroupModalTitle('添加分组集合');
      setPostGroupModalLable('分组集合');
    }else{
      setPostGroupModalTitle('添加分组'); // sub代表岗位
      setPostGroupModalLable('分组');
    }
  }
  //编辑自定义分组集合/分组
  function editCustomGroup(record){
    setAddOrEditPostGroupShow(true);
    setOperatePostGroupModalType("edit");
    setPostGroupModalLevel(record.level);
    setCurrentGroupData(record)
   //level为0的时候编辑的是岗位组 大于0的时候
   if(record.level===0){
    setPostGroupModalTitle('编辑分组集合');
    setPostGroupModalLable('分组集合');
   }else{
    setPostGroupModalTitle('编辑分组');
    setPostGroupModalLable('分组');
   }
  }
  function delCustomGroup(record){
    let title = '确认删除该分组集合吗？';
    let content= '删除后，该分组集合下的岗位及也将全部删除。';
   
    if(record.level>0){
      title = '确认删除该分组吗？';
      content = '删除后，不可恢复';
    }
     Modal.confirm({
       title,
       content,
       icon: <span className='icon iconfont default-confirm-icon'>&#xe6f4;</span>,
       okText: '确定',
       okType: 'danger',
       cancelText: '取消',
       onOk: () => {
         
       },
     });
   }


  function confirmAddOrEditPostGroup() {
    closeAddOrEditPostGroupModal();
    getTreeData()
  }

  return (
    <div className="left-structure-tree">
      <div className="organization">
          <div className="search-con">
            <Search
              placeholder="搜索部门/学员姓名"
              className="search search-input"
              style={{ width: 245 }}
              enterButton={<span className="icon iconfont">&#xe832;</span>}
            />
          </div>
          { (treeType==='postGrouptab' || treeType=== 'customGroupTab') && (
            <div className="operate">
              {treeType==='postGrouptab' && 
                <Button
                  className="add-btn"
                  onClick={() => {
                     addPostGroup(0)
                  }}
                >
                  添加岗位组
                </Button>
              }
              {treeType==='customGroupTab' && 
                <Button
                  className="add-btn"
                  onClick={() => {
                    addCustomGroup(0)
                  }}
                >
                  添加自定义分组
                </Button>
              }
            </div>
          )} 
        <div className="tree-con">
        <DirectoryTree
          defaultExpandAll
          showIcon={false}
          treeData={treeData}
          titleRender={(nodeData) => {
            return (
              <div
                className="node-title-div"
                onMouseOver={(e) => {
                  if (nodeData.key === "null") return;
                  let moreDiv = e.currentTarget.getElementsByClassName(
                    "item-more"
                  )[0];
                  let countDiv = e.currentTarget.getElementsByClassName(
                    "item-count"
                  )[0];
                  if (moreDiv) {
                    moreDiv.style.visibility = "visible";
                  }
                  if (countDiv) {
                    countDiv.style.visibility = "hidden";
                  }
                }}
                onMouseOut={(e) => {
                  if (nodeData.key === "null") return;
                  let moreDiv = e.currentTarget.getElementsByClassName(
                    "item-more"
                  )[0];
                  let countDiv = e.currentTarget.getElementsByClassName(
                    "item-count"
                  )[0];
                  if (moreDiv) {
                    moreDiv.style.visibility = "hidden";
                  }
                  if (countDiv) {
                    countDiv.style.visibility = "visible";
                  }
                }}
              >
                <div className="item-icon">
                <span className="icon iconfont title-icon">&#xe604;</span>
                </div>
                <div
                  className="item-title"
                  style={{
                    width:
                      leftBoxWidth <= "240px"
                        ? "35%"
                        : leftBoxWidth <= "304px"
                        ? "60%"
                        : "78%",
                  }}
                >
                  <span>{nodeData.name}</span>
                </div>
                <div className="item-count">({nodeData.departmentCount || 0})</div>
                { (treeType==='postGrouptab' || treeType=== 'customGroupTab') && (
                  <Dropdown overlay={moreOpenGroupOperate(nodeData)}>
                    <div className="item-more icon iconfont">&#xe927;</div>
                  </Dropdown>
                )}
              </div>
            );
          }}
        />
        </div>
      </div>
      {addOrEditPostGroupShow && (
        <AddOrEditPostGroupModal
          onClose={() => {
            closeAddOrEditPostGroupModal();
          }}
          onConfirm={() => {
            confirmAddOrEditPostGroup();
          }}
          title={postGroupModalTitle}
          postGroupModalLevel={postGroupModalLevel}
          modalOperateType={operatePostGroupModalType}
          postGroupName={postGroupName}
          postGroupTreeData={treeData}
          label={postGroupModalLable}
          currentTab={treeType}
          currentGroupData={currentGroupData}
        />
      )}
    </div>
  );
}

export default withRouter(LeftStructureTree);
