/*
 * @Author: 吴文洁
 * @Date: 2020-10-10 18:19:34
 * @LastEditors: renmanyi
 * @LastEditTime: 2026-02-03 15:39:33
 * @Description: 
 * @Copyright: 杭州杰竞科技有限公司 版权所有
 */
import OSS from 'ali-oss';
import COS from 'cos-js-sdk-v5';
import { UPLOAD_REGION } from '@/domains/resource-disk/constants';
import { getOssClient } from '@/data-source/basic/basic-apis';

interface IMultiPartUpload {
  data: object;
  instId: string;
  bizCode: string;
  resourceName: string;
  accessTypeEnum: string;
}

export default class UploadFileService {

  static getOssClient(multiPartUploadParams: IMultiPartUpload) {
    const { data, instId, bizCode, resourceName, accessTypeEnum } = multiPartUploadParams;
    return new Promise(resolve => {
      getOssClient(
        data,
        instId,
        bizCode,
        resourceName,
        accessTypeEnum
      ).then((res) => {
        const { result = {} } = res;
         const { bucket, resourceId, accessKeyId, securityToken, accessKeySecret, key, vendorType, callbackData, callback } = result;
          let client;
          if (vendorType === 'TENCENT_COS') {
            // 腾讯云配置
            client = new COS({
              SecretId: accessKeyId,
              SecretKey: accessKeySecret,
              SecurityToken: securityToken
            });
          } else {
            // 阿里云配置
            client = new OSS({
              bucket,
              accessKeyId,
              accessKeySecret,
              region: UPLOAD_REGION,
              stsToken: securityToken
            });
          }
          resolve({ ossClient: client, resourceId,  ossUri:key, vendorType,bucket,callbackData,callback });
      })
    })
  }
}